package com.example.afrishop_v3.controllers;

import com.alibaba.fastjson.JSONObject;
import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.config.DpoConfiguration;
import com.example.afrishop_v3.enums.DeliveryStatusEnum;
import com.example.afrishop_v3.enums.OrderStatusEnum;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.TbCfFinance;
import com.example.afrishop_v3.models.TbCfOrder;
import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.TbCfFinanceRepository;
import com.example.afrishop_v3.repository.TbCfOrderRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import com.example.afrishop_v3.util.DataUtils;
import com.example.afrishop_v3.util.HttpsUtil;
import com.example.afrishop_v3.util.IdUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

@RestController
@RequestMapping("/dpo")
public class DpoPayController extends Controller {
    private static Logger logger = LoggerFactory.getLogger(DpoPayController.class);

    private final TbCfOrderRepository repository;
    private final TbCfFinanceRepository financeRepository;
    private final AuthenticationUser user;
    private final DpoConfiguration config;

    public DpoPayController(TbCfOrderRepository repository, TbCfFinanceRepository financeRepository, AuthenticationUser user, DpoConfiguration config) {
        this.repository = repository;
        this.financeRepository = financeRepository;
        this.user = user;
        this.config = config;
    }


    @GetMapping("/notify")
    public Result payNotify(HttpServletRequest request, HttpServletResponse response) {
        Result result = new Result();
        try {
            System.out.println("DPO支付回调");
            //订单号
            String orderId = request.getParameter("CompanyRef");
            //交易ID
            String transId = request.getParameter("TransID");
            //交易令牌
            String transToken = request.getParameter("TransactionToken");
            System.err.println("transID:" + transId);
            System.err.println("transToken:" + transToken);
            //logger.info("DPO支付：" + "开始支付校验");
            if (!StringUtils.isBlank(orderId) && !StringUtils.isBlank(transToken)) {
                boolean verifyPay = verifyPay(transToken, orderId);
                if (verifyPay) {
                    //logger.info("DPO支付：" + "支付校验成功");
                    result.setMessage("Pay for success");
                    result.setCode(ResultCodeEnum.SUCCESS.getCode());
                    return result;
                }
            }
            return new Result<>(result,ResultCodeEnum.SERVICE_ERROR.getCode(), "Pay for failure");

        } catch (Exception e) {
            return new Result<>(result,ResultCodeEnum.SERVICE_ERROR.getCode(), "Pay for failure");
            //logger.error("DPO支付回调发生异常--->>>" + e.toString());
        }
    }

    @Transactional
    public boolean verifyPay(String transToken, String orderId) {
        boolean verify = false;
        try {
            Optional<TbCfOrder> byId = repository.findById(orderId);

            if( !byId.isPresent() ) return false;


            TbCfOrder order = byId.get();

            //如果数据库订单支付状态为20，说明已支付
            if (OrderStatusEnum.PAID.getValue().equals(order.getPayStatus())) {
                verify = true;
                return true;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            //拼接xml格式的参数，发送请求
            Map<String, Object> map = getParameters(transToken);
            String mapToXml = DataUtils.multilayerMapToXml(map, false);
            mapToXml = mapToXml.replaceAll("<xml>", "").replaceAll("</xml>", "");
            String resp = (String) HttpsUtil.sendHttps(config.getPaymentApi(), "POST", mapToXml, false);
            if (resp != null) {
                //将响应结果转成json格式
                String json = DataUtils.xml2json(resp);
                JSONObject jsonObject = JSONObject.parseObject(json);
                JSONObject api3G = jsonObject.getJSONObject("API3G");
                String resCode = api3G.getString("Result");
                //校验交易状态码
                if (config.getSuccessCode().equals(resCode)) {
                    TbCfUserInfo user = this.user.user();
                    if( user.hasFcm() ){
                    sendNotification(user.getFcm(), "Order alert !!", "Order of $" + order.getRealityPay() + " has been successfully paid !!");
                }
                    //获取缓存中的订单
//                    TbCfOrderVo tbCfOrderVo = (TbCfOrderVo) orderRedisCache.get(KeyConstant.ORDER_DET + orderId);
//                    //如果缓存中没有订单，则从数据库中查找
//                    if (tbCfOrderVo == null) {
//                        tbCfOrderVo = tbCfOrderDao.queryObject(orderId);
//                    }

                    /**
                     * 处理支付成功的业务：更新订单，优惠券状态，生成支付明细
                     */
                    //1.更新订单状态
                    changeOrderState(transToken, order);
                    //2.更新优惠券状态
                    /*if (!StringUtils.isBlank(tbCfOrderVo.getCouponId())) {
                        tbCfToiCouponDao.changeCoupnStatus(tbCfOrderVo.getUserId(), tbCfOrderVo.getCouponId());
                    }*/
                    //3.生成支付明细
                    String authurl = config.getRedirectUrl() + "?ID=" + transToken;
                    TbCfFinance finance = createFinance(transToken, authurl, order);
//                    TbCfFinanceVo tbCfFinanceVo = new TbCfFinanceVo();
//                    BeanUtils.copyProperties(finance, tbCfFinanceVo);
                    //校验数据库中订单支付状态
                    if (OrderStatusEnum.PAID.getValue().equals(order.getPayStatus())) {
                        //支付成功
                        logger.info("DPO支付：订单号" + orderId + "支付成功，支付时间：" + dateFormat.format(new Date()));
                        verify = true;
                        //清除缓存中的订单
                       // removeRedisCache(tbCfOrderVo);
                    }

                }
                if (!verify) {
                    logger.error("DPO支付：订单号" + orderId + "支付失败，支付时间：" + dateFormat.format(new Date()));
                    logger.error("DPO支付：状态码--->>>" + resCode);
                }
            }
        } catch (Exception e) {
            logger.error("DPO支付：订单号" + orderId + "支付异常--->>>" + e.toString());
        }
        return verify;
    }

    private void changeOrderState(String transToken, TbCfOrder order) {
        //更改订单状态
        order.setUpdateTime(new Date());
        order.setDealTime(new Date());
        order.setPayId(transToken);
        order.setOrderStatus(OrderStatusEnum.PAID.getValue());
        order.setPayStatus(OrderStatusEnum.PAID.getValue());
        order.setDeliveryFlag(DeliveryStatusEnum.PROCESSING.getValue());
        repository.save(order);
    }

    private TbCfFinance createFinance(String paymentId, String url, TbCfOrder tbCfOrderVo) {
        TbCfFinance tbCfFinance = new TbCfFinance();
        tbCfFinance.setOrderId(tbCfOrderVo.getOrderId());
        tbCfFinance.setFinaceId(IdUtil.createIdbyUUID());
        tbCfFinance.setPayAccount(tbCfOrderVo.getRealityPay());
        tbCfFinance.setPayId(paymentId);
        tbCfFinance.setPayTime(new Date());
        tbCfFinance.setReceiptUrl(url);
        tbCfFinance.setPayWayCode("dpo");
        tbCfFinance.setUserId(tbCfOrderVo.getUserId());
        financeRepository.save(tbCfFinance);
        return tbCfFinance;
    }


    @PostMapping("/payment")
    public Result payment(@RequestParam("orderId") String orderId) {


        if( orderId == null || orderId.trim().isEmpty())
            return new Result(ResultCodeEnum.ILLEGAL_ARGUMENT.getCode(),"Parameters cannot be empty");

        Optional<TbCfOrder> byId = repository.findById(orderId);

        if(!byId.isPresent())
            return new Result(ResultCodeEnum.ILLEGAL_ARGUMENT.getCode(),"Order not found !");

        TbCfOrder order = byId.get();

        if (OrderStatusEnum.PAID.getValue().equals(order.getPayStatus()) ){
            return new Result(ResultCodeEnum.ILLEGAL_ARGUMENT.getCode(),"Order has been paid !");
        }


        BigDecimal amount = order.getRealityPay();
        boolean amountFlag = amount.compareTo(BigDecimal.ZERO) > 0;
        //校验金额
        if (!amountFlag) {
//            logger.error("DPO支付：订单号" + orderId + "传入的金额有误");
//            payErrorInfo(result, "Wrong order amount");
            return new Result(ResultCodeEnum.ILLEGAL_ARGUMENT.getCode(),"Wrong order amount");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        //logger.info("DPO支付：订单号" + orderId + "创建交易，交易时间:" + dateFormat.format(new Date()));
        //拼接请求参数（将map对象转成xml格式）
        Map<String, Object> map = getParameters(order);
        String mapToXml = DataUtils.multilayerMapToXml(map, false);
        mapToXml = mapToXml.replaceAll("<xml>", "").replaceAll("</xml>", "");
        String resp = (String) HttpsUtil.sendHttps(config.getPaymentApi(), "POST", mapToXml, false);
        if (resp != null) {
            //将响应结果转成json格式
            String json = DataUtils.xml2json(resp);
            JSONObject jsonObject = JSONObject.parseObject(json);
            JSONObject api3G = jsonObject.getJSONObject("API3G");
            String resCode = api3G.getString("Result");
            String transToken = api3G.getString("TransToken");
            if (config.getSuccessCode().equals(resCode)) {
                HashMap<String,Object> resultMap = new HashMap<>();
                resultMap.put("transToken", transToken);
                resultMap.put("payUrl", config.getRedirectUrl() + "?ID=" + transToken);
                resultMap.put("orderInfo", order);
//                result.setData(resultMap);
//                logger.info("DPO支付：订单号" + orderId + "创建令牌成功");
                return new Result<>(resultMap,"Pay success");
            }
            //                logger.info("DPO支付：订单号" + orderId + "创建令牌失败,状态码：" + resCode);
            //                payErrorInfo(result, "DPO支付：订单号" + orderId + "创建令牌失败,状态码：" + resCode);

        }

        return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(),"DPO支付：订单号" + orderId + "创建令牌失败,状态码：");
    }

    private Map<String, Object> getParameters(String transToken) {
        Map<String, Object> paramMap = new HashMap<>();
        Map<String, Object> apiMap = new HashMap<>();
        apiMap.put("CompanyToken", config.getCompanyToken());
        apiMap.put("Request", config.getVerifyToken());
        apiMap.put("TransactionToken", transToken);
        paramMap.put("API3G", apiMap);
        return paramMap;
    }

    private Map<String, Object> getParameters(TbCfOrder order) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd hh:mm");
        Map<String, Object> paramMap = new HashMap<>();
        Map<String, Object> apiMap = new HashMap<>();
        Map<String, Object> tranMap = new HashMap<>();
        tranMap.put("Request", config.getCreateToken());
        tranMap.put("PaymentAmount", order.getRealityPay().setScale(2, BigDecimal.ROUND_UP));
        tranMap.put("PaymentCurrency", "USD");
        tranMap.put("CompanyRef", order.getOrderId());
        tranMap.put("CompanyRefUnique", 0);
        //回调地址
        if (order.getOrderSource() != null && "1".equals(order.getOrderSource().toString())) {
            tranMap.put("RedirectURL", config.getNotifyUrl());
        } else if (order.getOrderSource() != null && "2".equals(order.getOrderSource().toString())) {
            tranMap.put("RedirectURL", config.getNotifyUrl() + "/web");
        } else if (order.getOrderSource() != null && "3".equals(order.getOrderSource().toString())) {
            tranMap.put("RedirectURL", config.getNotifyUrl() + "/mobile");
        }
        System.out.println("回调地址:" + tranMap.get("RedirectURL"));
        //取消地址
        tranMap.put("BackURL", config.getBackUrl());
//        tranMap.put("PTL", 5);
        Map<String, Object> servicesMap = new HashMap<>();
        Map<String, Object> serviceMap = new HashMap<>();
        serviceMap.put("ServiceType", config.getServiceType());
        serviceMap.put("ServiceDescription", "DPO payment,name:" + order.getUserName() + ",amount:$" + order.getRealityPay());
        serviceMap.put("ServiceDate", dateFormat.format(new Date()));
        servicesMap.put("Service", serviceMap);
        apiMap.put("Transaction", tranMap);
        apiMap.put("Services", servicesMap);
        apiMap.put("CompanyToken", config.getCompanyToken());
        apiMap.put("Request", config.getCreateToken());
        paramMap.put("API3G", apiMap);
        return paramMap;
    }
}
