package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.TbCfToicoupon;
import com.example.afrishop_v3.repository.TbCfCouponRepository;
import com.example.afrishop_v3.repository.TbCfToicouponRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import org.springframework.web.bind.annotation.*;

import java.util.LinkedHashMap;
import java.util.List;

@RestController
@RequestMapping("/coupon")
public class CouponController {
    private final TbCfToicouponRepository repository;
    private final AuthenticationUser user;

    public CouponController(TbCfToicouponRepository repository, AuthenticationUser user) {
        this.repository = repository;
        this.user = user;
    }


    @GetMapping
    public Result getUserCoupons(){
        return queryCouponByUserId(user.userId());
    }


    @GetMapping("queryCouponByUserId")
    public Result queryCouponByUserId(@RequestParam("userId") String userId){
        List<TbCfToicoupon> availableCoupons = repository.queryUserAvailableCoupon(userId);
        List<TbCfToicoupon> expiredCoupons = repository.queryUserExpiredCoupon(userId);
        List<TbCfToicoupon> usedCoupons = repository.queryUserUsedCoupon(userId);

        LinkedHashMap<String, Object> hashMap = new LinkedHashMap<>();

        hashMap.put("validCouponList",availableCoupons);
        hashMap.put("usedCouponList",usedCoupons);
        hashMap.put("expiredCouponList",expiredCoupons);

        return new Result<>(hashMap);
    }


    @GetMapping("{couponId}")
    public Result queryCouponDetails(@PathVariable("couponId") String couponId){

        return new Result<>(repository.findById(couponId));
    }


    @GetMapping("take/{couponId}")
    public Result couponTake(@PathVariable("couponId") String couponId){
        // TODO
        //TbCfCouponEntity tbCfCouponEntity=grabCoupon(couponId);
//        if(tbCfCouponEntity!=null) {
//            //发放优惠券
//            //giveOutCoupon(tbCfUserInfoVo.getUserId(),tbCfCouponEntity);
//            //result.setData(tbCfCouponEntity);
//            //result.setMessage("Successfully received");
//        } else {
//        }
        return new Result(ResultCodeEnum.ERROR.getCode(),"The coupon has been snapped up");
    }
}
