package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.models.Comment;
import com.example.afrishop_v3.repository.CommentRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/discover/comment")
public class CommentController {
    private final CommentRepository repository;
    private final AuthenticationUser user;

    public CommentController(CommentRepository repository, AuthenticationUser user) {
        this.repository = repository;
        this.user = user;
    }

    @GetMapping(value = "/commentsByPostId/{postId}")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<Comment> getList(@PathVariable(value = "postId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAllByPostId(id, PageRequest.of(pageNo, pageSize)).toList();
    }



    @PostMapping(value ="/saveComment")
    public Comment saveProduct(@ModelAttribute("Comment") Comment comment){
        comment.setUserInfo(user.user());
        return repository.save(comment);
    }
}
