package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.base.StateConstant;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.TbCfCartRecordR;
import com.example.afrishop_v3.models.TbCfExpressTemplate;
import com.example.afrishop_v3.models.TbCfStationItem;
import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.TbCfCartRecordRRepository;
import com.example.afrishop_v3.repository.TbCfExpressTemplateRepository;
import com.example.afrishop_v3.repository.TbCfStationItemRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import com.example.afrishop_v3.util.ValidateUtils;
import com.example.afrishop_v3.util.WordposHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

@RestController
@RequestMapping("/cart")
public class CartController extends Controller {
    private final TbCfCartRecordRRepository repository;
    private final TbCfStationItemRepository itemRepository;
    private final TbCfExpressTemplateRepository templateRepository;
    private final AuthenticationUser user;

    public CartController(TbCfCartRecordRRepository repository, TbCfStationItemRepository itemRepository, TbCfExpressTemplateRepository templateRepository, AuthenticationUser user) {
        this.repository = repository;
        this.itemRepository = itemRepository;
        this.templateRepository = templateRepository;
        this.user = user;
    }


    @PutMapping("/num/{cartId}/{itemNum}")
    public Result changeItemNum(@PathVariable String cartId, @PathVariable int itemNum) {
        Optional<TbCfCartRecordR> byId = repository.findById(cartId);
        if (byId.isPresent()) {
            TbCfCartRecordR record = byId.get();
            record.setItemNum(itemNum);
            repository.save(record);
            return new Result<>(ResultCodeEnum.SUCCESS.getCode(), "Item quantity updated");
        }

        return new Result<>(ResultCodeEnum.SERVICE_ERROR.getCode(), "Failed");
    }

    @PostMapping
    public Result addToCart(@RequestBody TbCfCartRecordR itemDetail) {

        TbCfUserInfo user = this.user.user();

        String userId = user.getUserId();

        if (itemDetail == null) {
            return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(), "Request body is empty");
        }

        int count = repository.countByUserId(userId);

        if (count > 99) {
            return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(), "Your shopping cart is full");
        }

        BigDecimal price = itemDetail.getItemPrice();

        if (price == null || price.compareTo(BigDecimal.ZERO) <= 0) {
            return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(), "The price of the goods is incorrect");
        }


        Optional<TbCfCartRecordR> optionalItem;
        String itemId = itemDetail.getItemId();
        boolean hasItemId = itemId != null && !itemId.isEmpty();
        if (hasItemId) {
            optionalItem = repository.findFirstByUserIdAndItemImgAndItemSku(userId,itemDetail.getItemImg(), itemDetail.getItemSku());
        } else {
            optionalItem = repository.findFirstByUserIdAndSourceItemIdAndItemSku(userId,itemDetail.getSourceItemId(), itemDetail.getItemSku());
        }

        TbCfCartRecordR detail;

        if (optionalItem.isPresent()) {

            detail = optionalItem.get();

            itemId = detail.getItemId();

        } else {
            itemId = itemId != null && !itemId.isEmpty() ? itemId : uid();
            updateItemCategory(itemDetail);
        }

        // Check if the item exist in cart
        Optional<TbCfCartRecordR> cartOptional = repository.findFirstByUserIdAndItemIdAndItemSku(userId, itemId, itemDetail.getItemSku());

        if (cartOptional.isPresent()) {
            TbCfCartRecordR cart = cartOptional.get();
            cart.increaseNum(itemDetail.getItemNum());
            repository.save(cart);
        } else {
            //detail.setItemNum(itemDetail.getItemNum());
            insertRecord(itemDetail, userId);
        }


        if( user.hasFcm() ){
            int i = repository.countByUserId(userId);
            sendNotification(user.getFcm(),"Cart updates","Item added to cart, "+i+" item(s) are pending, continue with order");
        }


        return new Result();
    }


    @GetMapping
    public Result getItemCartList() {
        return new Result<>(repository.findAllByUserIdOrderByCreateTimeDesc(user.userId()));
    }

    @DeleteMapping("/delete")
    public Result deleteItems(@RequestBody String[] ids) {
        if (ids != null) {
            repository.deleteAllByCartRecordIdIn(ids);
            return new Result();
        }
        return new Result(ResultCodeEnum.SERVICE_ERROR.getCode(),
                ResultCodeEnum.SERVICE_ERROR.getDesc());
    }


    private void insertRecord(TbCfCartRecordR itemDetail, String userId) {
        itemDetail.setCartRecordId(uid());
        itemDetail.setCheckFlag(StateConstant.INVALID);
        itemDetail.setEnableFlag(StateConstant.VALID);
        itemDetail.setUserId(userId);
        itemDetail.setCreateTime(new Date());
        repository.save(itemDetail);
    }


    private TbCfCartRecordR updateItemCategory(TbCfCartRecordR tbCfItemDetail) {

        Optional<TbCfStationItem> byId = itemRepository.findById(tbCfItemDetail.getItemId());
        if (byId.isPresent() && byId.get().getExpress() != null) {
            tbCfItemDetail.setTemplate(byId.get().getExpress());
        } else {

//            if( byId.isPresent() ){
//                TbCfExpressTemplate templateIdAsc = templateRepository.findFirstByOrderByTemplateIdAsc();
//
//                if (templateIdAsc != null)
//                    tbCfItemDetail.setTemplate(templateIdAsc);
//            } else {
//            System.out.println("No template, keep processing");
//                TbCfExpressTemplate expressTemplate = null;
//                try {
//                    expressTemplate = recognizeItemCategory(tbCfItemDetail.getItemTitle());
//                } catch (Exception e) {
//                    System.out.println(e.getMessage());
//                }
//                if (expressTemplate != null) {
//                    tbCfItemDetail.setItemCategory(expressTemplate.getTemplateId());
//                    tbCfItemDetail.setTemplate(expressTemplate);
//                }else{
//
//                    // For crawling products
//                    Optional<TbCfExpressTemplate> templateOptional = templateRepository.findFirstByIsDefault(1);
//
//                    if ( templateOptional.isPresent() ){
//                        TbCfExpressTemplate template = templateOptional.get();
//                        tbCfItemDetail.setItemCategory(template.getTemplateId());
//                        tbCfItemDetail.setTemplate(template);
//                    }
//                }
            //}
        }


        return tbCfItemDetail;
        //logger.info("插入一条商品数据！");
    }

    private TbCfExpressTemplate recognizeItemCategory(String itemTitle) throws ExecutionException, InterruptedException, TimeoutException {
        Map<String, Object> wordResult = separateText(itemTitle);
        //pos_code 16为名词，用名词去匹配; 23非汉字串
        JSONArray baseTokens = (JSONArray) wordResult.get("base_tokens");
        List<String> keywordList = new ArrayList<>();
        for (Object baseToken : baseTokens) {
            JSONObject jsonObject = (JSONObject) baseToken;
            if (16 == (Integer) jsonObject.get("pos_code")) {
                keywordList.add((String) jsonObject.get("word"));
            }
            if (23 == (Integer) jsonObject.get("pos_code")) {
                keywordList.add((String) jsonObject.get("word"));
            }
        }
        //总的可能适用的运费模板
        Set<TbCfExpressTemplate> totalTemplateSet = new HashSet<>();
        if (!keywordList.isEmpty()) {
            for (String keyword : keywordList) {
                //根据keyword获取运费模板
                List<TbCfExpressTemplate> tbCfExpressTemplateList = templateRepository.getTemplateByKeyword(keyword);
                totalTemplateSet.addAll(tbCfExpressTemplateList);
                //TODO 后续优化
                if (ValidateUtils.isContainChinese(keyword)) {
                    if (0 == tbCfExpressTemplateList.size()) {
                        String[] split = keyword.split("");
                        for (int i = 0; i < split.length; i++) {
                            if (i + 1 <= split.length) {
                                List<TbCfExpressTemplate> tbCfExpressTemplateLists = templateRepository.getTemplateByKeyword(split[i] + split[i + 1]);
                                totalTemplateSet.addAll(tbCfExpressTemplateLists);
                            }
                        }
                    }
                }
            }
        }
        //没有的话就设置 其他
        if (totalTemplateSet.isEmpty()) {
            //根据keyword获取运费模板
            List<TbCfExpressTemplate> tbCfExpressTemplateList = templateRepository.getTemplateByKeyword("其他");
            totalTemplateSet.addAll(tbCfExpressTemplateList);
        }
        //取第一个运费
        Iterator<TbCfExpressTemplate> iterator = totalTemplateSet.iterator();
        return iterator.next();
    }


    private Map<String, Object> separateText(String text) throws ExecutionException, InterruptedException, TimeoutException {
        List<Map<String, Object>> futureList = new ArrayList<>();
        Map<String, Object> titleMap = new HashMap<>();
        titleMap.put("text", text);
        WordposHelper.separeteText(futureList, titleMap, text);
        WordposHelper.waitForResult(futureList);
        return titleMap;
    }

}
