package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.base.StateConstant;
import com.example.afrishop_v3.config.DomainProperties;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.enums.SexEnum;
import com.example.afrishop_v3.enums.UserTypeEnum;
import com.example.afrishop_v3.models.Network;
import com.example.afrishop_v3.models.TbCfCoupon;
import com.example.afrishop_v3.models.TbCfToicoupon;
import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.payload.request.LoginRequest;
import com.example.afrishop_v3.repository.NetworkRepository;
import com.example.afrishop_v3.repository.TbCfCouponRepository;
import com.example.afrishop_v3.repository.TbCfToicouponRepository;
import com.example.afrishop_v3.repository.UserRepository;
import com.example.afrishop_v3.security.jwt.JwtUtils;
import com.example.afrishop_v3.security.services.UserDetailsImpl;
import com.example.afrishop_v3.util.IdUtil;
import org.hashids.Hashids;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.web.bind.annotation.*;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@CrossOrigin(origins = "*", maxAge = 3600)
@RestController
@RequestMapping("/api/auth")
public class AuthController extends Controller {
    private final AuthenticationManager authenticationManager;

    private final UserRepository userRepository;
    private final TbCfCouponRepository couponRepository;
    private final TbCfToicouponRepository toicouponRepository;
    private final NetworkRepository networkRepository;
    private final EntityManager entityManager;


    private final PasswordEncoder encoder;
    private final DomainProperties domainProperties;

    private final JwtUtils jwtUtils;

    public AuthController(AuthenticationManager authenticationManager, UserRepository userRepository, TbCfCouponRepository couponRepository, TbCfToicouponRepository toicouponRepository, NetworkRepository networkRepository, EntityManager entityManager, PasswordEncoder encoder, DomainProperties domainProperties, JwtUtils jwtUtils) {
        this.authenticationManager = authenticationManager;
        this.userRepository = userRepository;
        this.couponRepository = couponRepository;
        this.toicouponRepository = toicouponRepository;
        this.networkRepository = networkRepository;
        this.entityManager = entityManager;
        this.encoder = encoder;
        this.domainProperties = domainProperties;
        this.jwtUtils = jwtUtils;
    }

    @PostMapping("/signin")
    public Result authenticateUser(@RequestBody LoginRequest loginRequest) {
        Optional<TbCfUserInfo> byAccount = userRepository.findFirstByAccount(loginRequest.getAccount());
        Result<Object> notFound = new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "User not found");
        if (!byAccount.isPresent()) {
//
//            boolean b = userRepository.existsByAccount(loginRequest.getAccount());
//
//            if (b) {
//                Optional<TbCfUserInfo> firstByAccount = userRepository.findFirstByAccount(loginRequest.getAccount());
//                if (firstByAccount.isPresent()) {
//                    TbCfUserInfo userInfo = firstByAccount.get();
//                    userInfo.setFirebaseUid(loginRequest.getAccount());
//                    fixCode(userInfo);
//                    try {
//                        userRepository.save(userInfo);
//                    } catch (Exception e) {
//                        return notFound;
//                    }
//                    byAccount = Optional.of(userInfo);
//                } else return notFound;
//            } else
                return notFound;
        }

        Authentication authentication;
        try {
            authentication = authenticationManager.authenticate(
                    new UsernamePasswordAuthenticationToken(loginRequest.getAccount(), loginRequest.getPassword()));
        } catch (BadCredentialsException e) {
            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Invalid username or password");
        }

        SecurityContextHolder.getContext().setAuthentication(authentication);
        String jwt = jwtUtils.generateJwtToken(authentication);

        UserDetailsImpl userDetails = (UserDetailsImpl) authentication.getPrincipal();
//        List<String> roles = userDetails.getAuthorities().stream()
//                .map(GrantedAuthority::getAuthority)
//                .collect(Collectors.toList());

        TbCfUserInfo userInfo = byAccount.get();

        userInfo.setToken(jwt);

        if (loginRequest.getFcm() != null) {
            userInfo.setFcm(loginRequest.getFcm());
        }


        userInfo.setLastLoginTime(new Date());
        userInfo.setUserType(UserTypeEnum.EMAIL.getCode());
        userRepository.save(userInfo);

        if (userInfo.hasFcm()) {
            sendNotification(userInfo.getFcm(), "Welcome ", userInfo.display() + ", Welcome and start shopping !!!");
        }

        return new Result<>(userInfo);
    }


    @PostMapping("/signup")
    public Result<?> registerUser(@RequestBody TbCfUserInfo signUpRequest) {
        try {
//			boolean byAccount = userRepository.existsByAccount(signUpRequest.getEmail());
//			if ( byAccount ) {
//				return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(),"Error: Username is already taken!");
//			}

            String email = signUpRequest.getEmail();

            String password = signUpRequest.getPassword();

            email = email == null ? "" : email.trim();


            if (email.isEmpty()) {
                return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Email is empty");
            }

            if (!isEmailValid(email)) {
                return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Invalid email");
            }

            if (password == null || password.isEmpty()) {
                return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Password is Empty");
            }

            if (!isPasswordValid(password)) {

                String string = "Password is not strong";

                if (!isPasswordValidDigit(password)) {
                    string += ", a digit must occur at least once";
                }

                if (!isPasswordValidUpperCase(password)) {
                    string += ", an upper case letter must occur at least once";
                }

                if (!isPasswordValidLength(password)) {
                    string += ", at least eight characters though";
                }

                return new Result<>(ResultCodeEnum.VALIDATE_ERROR.getCode(), string);
            }

            boolean byEmail = userRepository.existsByFirebaseUid(email);
            boolean byEmail2 = userRepository.existsByAccount(email);

            if (byEmail || byEmail2) {
                return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Error: Email is already in use!");
            }


            //signUpRequest.setFirebaseUid(email);
            signUpRequest.setAccount(email);

            signUpRequest.setUserId(IdUtil.createIdbyUUID());

            fillUserNecessayInfo(signUpRequest);

            signUpRequest.setPassword(encoder.encode(password));

            signUpRequest.setLastLoginTime(new Date());


            fixCode(signUpRequest);

            signUpRequest.setUserType(UserTypeEnum.EMAIL.getCode());

            TbCfUserInfo userInfo = userRepository.save(signUpRequest);


            //addToNetwork(signUpRequest);


            fixCoupon(signUpRequest);

            return authenticateUser(new LoginRequest(userInfo.getAccount(), password, userInfo.getFcm()));
        } catch (Exception e) {
            System.out.println(e.getMessage());
            return new Result<>(ResultCodeEnum.SERVICE_ERROR.getCode(), e.getMessage());
        }
    }


    @PostMapping(value = "/register/user")
    public Result checkFirebase(@RequestBody TbCfUserInfo user) {
        //Data to be userInfoVo
//        {
//            "firebaseUid":"firebaseUid",
//            "name":"name",
//            "email":"email",
//            "phone":"phone",
//            "birthDate":"date",
//            "token":"token",
//        }

        // Check if firebase token is valid

           boolean isTokenValid = user.getToken() != null && validateFirebaseToken(user.getToken());


           String firebaseUid = user.getFirebaseUid();

           // if valid do sign in if firebase Uid exist in database or register as new user
           if (isTokenValid) {
               //Query to find user from database by firebase uid
               Optional<TbCfUserInfo> optional = userRepository.findByFirebaseUid(firebaseUid);

               if (!optional.isPresent() && user.getEmail() != null && !user.getEmail().isEmpty() && userRepository.existsByAccount(user.getEmail())) {
                   optional = userRepository.findFirstByAccount(user.getEmail());
               }

               if (!optional.isPresent() && user.getPhone() != null && !user.getPhone().isEmpty() && userRepository.existsByAccount(user.getPhone().replace("+", ""))) {
                   optional = userRepository.findFirstByAccount(user.getPhone().replace("+", ""));
               }

               if (!optional.isPresent()) {


                   String userid = IdUtil.createIdbyUUID();

                   // user.setPassword(encoder.encode(firebaseUid));
                   user.setUserId(userid);

                   fillUserNecessayInfo(user);
                   user = userRepository.save(user);


                   //赠送用户优惠券
                   fixCoupon(user);
               } else {
                   TbCfUserInfo userInfo = optional.get();

                   if (user.hasFcm()) {
                       userInfo.setFcm(user.getFcm());
                   }

                   if (userInfo.getFirebaseUid() == null) {
                       userInfo.setFirebaseUid(firebaseUid);
                   }

                   String property = domainProperties.getProperty("user.avatar");

                   property = property == null ? "" : property;

                   boolean b = property.equals(userInfo.getAvatar()) || userInfo.getAvatar() == null || userInfo.getAvatar().isEmpty();


                   if (user.getAvatar() != null && b) {
                       userInfo.setAvatar(user.getAvatar());
                   }

                   boolean b1 = userInfo.getNick() == null || userInfo.getNick().isEmpty();
                   if (user.getNick() != null && b1) {
                       userInfo.setNick(user.getNick());
                   }

                   if (user.getEmail() != null) {
                       userInfo.setEmail(user.getEmail());
                   }

                   if (user.getUserType() != null) {
                       userInfo.setUserType(user.getUserType());
                   }

                   if (user.getPhone() != null) {
                       userInfo.setPhone(user.getPhone());
                   }

                   user = userInfo;

               }




               fixCode(user);

               //addToNetwork(user);

               user.setLastLoginTime(new Date());
               userRepository.save(user);
               //注册成功 创建token


               Authentication authentication;
               try {
                   authentication = new UsernamePasswordAuthenticationToken(UserDetailsImpl.build(user), null);
               } catch (BadCredentialsException e) {
                   return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Invalid username or password");
               }

               SecurityContextHolder.getContext().setAuthentication(authentication);
               String jwt = jwtUtils.generateJwtToken(authentication);

               user.setToken(jwt);

               return new Result<>(user);


           } else {
               return new Result<>(ResultCodeEnum.ILLEGAL_ARGUMENT.getCode(), ResultCodeEnum.ILLEGAL_ARGUMENT.getDesc());
           }



    }


    private void fixCoupon(TbCfUserInfo user) {
        try {
            List<TbCfCoupon> couponVailList = couponRepository.findAllByCouponVaild(1);
            //获取当前时间的时分秒
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");//设置日期格式
            Calendar c = Calendar.getInstance();
            c.add(Calendar.DATE, +7);
            Date time = c.getTime();
            Date startDate = sdf.parse(sdf.format(new Date()));
            Date endDate = sdf.parse(sdf.format(time));
            for (TbCfCoupon tbCfCoupon : couponVailList) {
                TbCfToicoupon toi = new TbCfToicoupon();
                //把上面获取到的值，赋值到实体类中
                toi.setToitableId(IdUtil.createIdbyUUID());
                toi.setCoupon(tbCfCoupon);
                toi.setUserId(user.getUserId());
                toi.setStartTime(startDate);
                toi.setIdentification(3);
                toi.setEnableFlag(1);
                toi.setEndTime(endDate);
                toicouponRepository.save(toi);
            }
        } catch (Exception e) {

        }
    }

    private void fixCode(TbCfUserInfo user) {

        if (user.getCode() == null) {
            try {
                Query nativeQuery = entityManager.createNativeQuery("select b.code as data FROM user_info b where b.external_id=:user limit 1");

                nativeQuery.setParameter("user", user.getUserId());

                if (nativeQuery.getSingleResult() != null) {
                    user.setCode(nativeQuery.getSingleResult().toString());
                }
            } catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }

        if (user.getCode() == null) {
            Hashids hashids = new Hashids("big_afr_dev", 6);
            Long codeCount = user.getCodeCount();

            Calendar cal = Calendar.getInstance();
            long currentTime = cal.getTimeInMillis();
            long Max = 9999999999999L;
            long Min = 1000000000000L;
            long range = Math.abs((long) (Math.random() * (Max - Min)) + Min);
            long id = Math.addExact(currentTime, range);

            if (codeCount == null) {
                id = userRepository.count() + id;
            }

            user.setCode(hashids.encode(id));
        }
    }

    private void addToNetwork(TbCfUserInfo user) {
        Network top = networkRepository.findTopByOrderByIdDesc();

        if (top != null && !user.invited()) {
            if (!networkRepository.existsByUserInfo_UserIdAndNetworkInfo_UserId(top.getNetworkId(), user.getUserId())) {
                Network network = new Network();
                network.setUserInfo(top.getNetworkInfo());
                network.setNetworkInfo(user);
                //network.setId(uid());
                networkRepository.save(network);
                user.setInvitation(1);
            }
        }
    }

    private void fillUserNecessayInfo(TbCfUserInfo tbCfUserInfoVo) {
        if (tbCfUserInfoVo.getAvatar() == null) tbCfUserInfoVo.setAvatar(domainProperties.getProperty("user.avatar"));
        tbCfUserInfoVo.setUserNo(IdUtil.createIdByDate());
        tbCfUserInfoVo.setPhoneFlag(StateConstant.INVALID);
        tbCfUserInfoVo.setLoginCount(0);
        tbCfUserInfoVo.setCreateTime(new Date());
        tbCfUserInfoVo.setSex(SexEnum.UNKNOW.getCode());
        tbCfUserInfoVo.setInvitedCount(0);
        tbCfUserInfoVo.setEnableFlag(StateConstant.VALID);
        //目前有验证码的都是邮箱类型
        if (tbCfUserInfoVo.getUserType() == null)
            tbCfUserInfoVo.setUserType(UserTypeEnum.UN_KNOW.getCode());
        tbCfUserInfoVo.setEmailFlag(StateConstant.INVALID);
    }
}
