package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.base.StateConstant;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.TbCfAddress;
import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.TbCfAddressRepository;
import com.example.afrishop_v3.repository.UserRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import org.springframework.web.bind.annotation.*;

import java.util.Optional;

@RestController
@RequestMapping("/address")
public class AddressController extends Controller{
    private final TbCfAddressRepository repository;
    private final UserRepository userRepository;
    private final AuthenticationUser user;

    public AddressController(TbCfAddressRepository repository, UserRepository userRepository, AuthenticationUser user) {
        this.repository = repository;
        this.userRepository = userRepository;
        this.user = user;
    }

    @GetMapping
    public Result<Iterable<TbCfAddress>> getUserInfoList() {
        Iterable<TbCfAddress> tbCfAddressVoList = repository.findAllByUserId(user.userId());
        return new Result<>(tbCfAddressVoList);
    }

    @PostMapping
    public Result addUserInfo(@RequestBody TbCfAddress address) {
        ResultCodeEnum e = ResultCodeEnum.VALIDATE_ERROR;
        String userId = user.userId();
        if( address == null )
            return new Result(e.getCode(),e.getDesc());
        if( address.getAddressDetail() == null || address.getAddressDetail().trim().isEmpty())
            return new Result(e.getCode(),"Address is required");
        if( address.getDeliveryName() == null || address.getDeliveryName().trim().isEmpty())
            return new Result(e.getCode(),"Delivery name is required");
        if( address.getPhone() == null || address.getPhone().trim().isEmpty())
            return new Result(e.getCode(),"Phone is required");
        if( repository.existsByAddressDetailAndUserId(address.getAddressDetail().trim(), userId))
            return new Result(e.getCode(),"Address already existed");


        address.setAddressDetail(address.getAddressDetail().trim());
        address.setUserId(userId);
        address.setAddressId(uid());
        return new Result<>(repository.save(address));
    }

    @PutMapping("/{addressId}")
    public Result editAddressInfo(@PathVariable("addressId") String addressId,@RequestBody TbCfAddress address) {

        ResultCodeEnum e = ResultCodeEnum.VALIDATE_ERROR;
        if( !repository.existsById(addressId) )
            return new Result(e.getCode(),"Address doesn't exist");

        String userId = user.userId();
        if( address == null )
            return new Result(e.getCode(),e.getDesc());
        if( address.getAddressDetail() == null || address.getAddressDetail().trim().isEmpty())
            return new Result(e.getCode(),"Address is required");
        if( address.getDeliveryName() == null || address.getDeliveryName().trim().isEmpty())
            return new Result(e.getCode(),"Delivery name is required");
        if( address.getPhone() == null || address.getPhone().trim().isEmpty())
            return new Result(e.getCode(),"Phone is required");

        if( repository.existsByAddressDetailAndUserIdAndAddressIdIsNot(address.getAddressDetail().trim(), userId,addressId))
            return new Result(e.getCode(),"Address already existed");

        address.setAddressDetail(address.getAddressDetail().trim());
        address.setAddressId(addressId);
        address.setUserId(userId);
        return new Result<>(repository.save(address));
    }

    @DeleteMapping("/{addressId}")
    public Result deleteAddressInfo(@PathVariable("addressId") String addressId) {
        Optional<TbCfAddress> byId = repository.findById(addressId);
        if( byId.isPresent() ){
            TbCfAddress address = byId.get();

            TbCfUserInfo user = this.user.user();
            TbCfAddress cfAddress = user.getAddress();

            if( cfAddress != null && cfAddress.getAddressId().equals(address.getAddressId())){
                user.setAddress(null);
                userRepository.save(user);
            }

            repository.delete(address);
        }
        return new Result<>();
    }

    @PutMapping(value = "/default/{addressId}")
    public Result configDefaultAddress(@PathVariable("addressId") String addressId) {
        Optional<TbCfAddress> byId = repository.findById(addressId);

        if( byId.isPresent() ){
            TbCfAddress address = byId.get();
            TbCfUserInfo user = this.user.user();


            repository.resetToDefault(user.getUserId());

            address.setDefaultFlag(StateConstant.VALID);
            repository.save(address);
            user.setAddress(address);
            userRepository.save(user);


            return new Result<>(ResultCodeEnum.SUCCESS.getDesc());

        }

        return new Result<>().setCode(ResultCodeEnum.ERROR.getCode()).setMessage(ResultCodeEnum.ERROR.getDesc());
    }




    @GetMapping(value = "/default")
    public Result getDefaultAddress() {
        TbCfAddress address = user.user().getAddress();

        return new Result<>(address, address == null ? ResultCodeEnum.SERVICE_ERROR.getCode() : ResultCodeEnum.SUCCESS.getCode(),"");
    }
}
