package com.example.afrishop_v3.web.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.TbCfSolve;
import com.example.afrishop_v3.repository.TbCfSolveRepository;
import com.example.afrishop_v3.util.IdUtil;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/website/solve")
public class SolveController {
    private final TbCfSolveRepository repository;

    public SolveController(TbCfSolveRepository repository) {
        this.repository = repository;
    }

    @PostMapping("/save")
    public Result save(@RequestBody TbCfSolve tbCfSolve) {
        tbCfSolve.setId(IdUtil.createIdbyUUID());
        TbCfSolve cfSolve = repository.save(tbCfSolve);
        return new Result<>(cfSolve);
    }
}
