package com.example.afrishop_v3.web.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.TbCfGoodstwotype;
import com.example.afrishop_v3.models.TbCfGoodstype;
import com.example.afrishop_v3.repository.TbCfGoodstwotypeRepository;
import com.example.afrishop_v3.repository.TbCfGoodstypeRepository;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/website/column2")
public class Column2Controller {

    private final TbCfGoodstypeRepository repository;
    private final TbCfGoodstwotypeRepository goodstwotypeRepository;

    public Column2Controller(TbCfGoodstypeRepository repository, TbCfGoodstwotypeRepository goodstwotypeRepository) {
        this.repository = repository;
        this.goodstwotypeRepository = goodstwotypeRepository;
    }

    @GetMapping
    public Result getAllColumn() {
        Iterable<TbCfGoodstype> all = repository.findAll();
        return new Result<>(all);
    }

    @GetMapping("/{id}")
    public Result getColumnChildren(@PathVariable String id) {

        List<TbCfGoodstwotype> list = goodstwotypeRepository.findAllByGoodstypeIdOrderBySort(id);
        list.forEach(TbCfGoodstwotype::enableAutoLoad);
        return new Result<>(list);
    }

}
