package com.example.afrishop_v3.util;

import com.squareup.okhttp.*;
import net.sf.json.JSONObject;
import org.springframework.beans.factory.annotation.Value;

import java.io.IOException;

public class PayPalUtil {

    /**
     * paypal token 默认是8小时有效
     * 以旧token（必须是未失效的）才能换新token
     * 如果不刷新token，8小时后paypal将无法使用
     */
    public static String getToken(String oldToken, String mode) throws IOException {
        OkHttpClient client = new OkHttpClient();

        String url;
        if ("live".equalsIgnoreCase(mode)) {
            url = "https://api.paypal.com/v1";
        } else {
            url = "https://api.sandbox.paypal.com/v1";
        }
        MediaType mediaType = MediaType.parse("application/x-www-form-urlencoded");
        RequestBody body = RequestBody.create(mediaType, "grant_type=client_credentials");
        Request request = new Request.Builder()
                .url(url + "/oauth2/token")
                .post(body)
                .addHeader("Content-Type", "application/x-www-form-urlencoded")
                .addHeader("Authorization", oldToken)
                .addHeader("cache-control", "no-cache")
                .build();

        Response response = client.newCall(request).execute();
        String string = response.body().string();
        net.sf.json.JSONObject jsonObject = JSONObject.fromObject(string);
        String token_type = jsonObject.getString("token_type");
        String access_token = jsonObject.getString("access_token");
        String token = String.format("%s %s", token_type, access_token);
        return token;
    }
}
