package com.example.afrishop_v3.util;


import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.Bucket;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import org.springframework.web.multipart.MultipartFile;

import java.io.*;
import java.net.URL;
import java.util.Date;

public class OssUtil {
	////////// 阿里云要求jdom使用1.1版本！！！！！！！！！！！！！

	 //阿里云API的内或外网域名
	 private static final String ENDPOINT="oss-cn-shenzhen.aliyuncs.com";
	 //阿里云API的密钥Access Key ID
	 private static final String ACCESS_KEY_ID="5d6h34keSd9K3l2x";
	 //阿里云API的密钥Access Key Secret
	 private static final String ACCESS_KEY_SECRET="l2dJ4LpY6D6qV3jj3iQif7EPByoVQE";
	 //阿里云API的bucket名称
	 private static final String BACKET_NAME="diaosaas-prod";
	 //阿里云API的文件夹名称
	 private static final String FOLDER="africa-shop/";
//	// 阿里云API的内或外网域名
//	private static final String ENDPOINT = "oss-cn-shenzhen.aliyuncs.com";
//	// 阿里云API的密钥Access Key ID
//	private static final String ACCESS_KEY_ID = "5d6h34keSd9K3l2x";
//	// 阿里云API的密钥Access Key Secret
//	private static final String ACCESS_KEY_SECRET = "l2dJ4LpY6D6qV3jj3iQif7EPByoVQE";
//	// 阿里云API的bucket名称
//	private static final String BACKET_NAME = "diaosaas-prod";
//	// 阿里云API的文件夹名称
//	private static final String FOLDER = "wosenad/";

	/**
	 * 获取阿里云OSS客户端对象
	 * 
	 * @return
	 */
	public static OSSClient getOSSClient() {
		return new OSSClient(ENDPOINT, ACCESS_KEY_ID, ACCESS_KEY_SECRET);
	}

	/**
	 * 创建存储空间
	 * 
	 * @param ossClient
	 * @param bucketName
	 * @return
	 */
	public static String createBucketName(OSSClient ossClient, String bucketName) {
		// 存储空间
		final String bucketNames = bucketName;
		if (!ossClient.doesBucketExist(bucketName)) {
			// 创建存储空间
			Bucket bucket = ossClient.createBucket(bucketName);
			return bucket.getName();
		}
		return bucketNames;
	}

	/**
	 * 删除存储空间
	 * 
	 * @param ossClient
	 * @param bucketName
	 */
	public static void deleteBucket(OSSClient ossClient, String bucketName) {
		ossClient.deleteBucket(bucketName);
	}

	/**
	 * 创建模拟文件夹
	 * 
	 * @param ossClient
	 *            oss连接
	 * @param bucketName
	 *            存储空间
	 * @param folder
	 *            模拟文件夹名如"wenjianjia/"
	 * @return
	 */
	public static String createFolder(OSSClient ossClient, String bucketName, String folder) {
		// 文件夹名
		final String keySuffixWithSlash = folder;
		// 判断文件夹是否存在,不存在则创建
		if (!ossClient.doesObjectExist(bucketName, keySuffixWithSlash)) {
			// 创建文件夹
			ossClient.putObject(bucketName, keySuffixWithSlash, new ByteArrayInputStream(new byte[0]));
			;
			// 得到文件夹名
			OSSObject object = ossClient.getObject(bucketName, keySuffixWithSlash);
			String fileDir = object.getKey();
			return fileDir;
		}
		return keySuffixWithSlash;
	}

	/**
	 * 根据key和folder删除OSS服务器上的文件
	 * 
	 * @param bucketName
	 *            bucketName存储空间
	 * @param folder
	 *            folder模拟文件夹名 如"qj_nanjing/"
	 * @param key
	 *            Bucket下的文件的路径名+文件名 如:"upload/cake.jpg"
	 */
	public static String deleteFile(String bucketName, String folder, String key) {
		OSSClient ossClient = getOSSClient();
		try {
			ossClient.deleteObject(bucketName, folder + key);
			return "success";
		} catch (Exception e) {
			e.printStackTrace();
			return "error";
		} finally {
			ossClient.shutdown();
		}
	}

	/**
	 * 根据key删除OSS服务器上的文件
	 * 
	 * @param bucketName
	 *            bucketName存储空间
	 * @param key
	 *            Bucket下的文件的路径名+文件名 如:"upload/cake.jpg"
	 */
	public static String deleteFile(String bucketName, String key) {
		OSSClient ossClient = getOSSClient();
		try {
			ossClient.deleteObject(bucketName, key);
			return "success";
		} catch (Exception e) {
			e.printStackTrace();
			return "error";
		} finally {
			ossClient.shutdown();
		}
	}

	/**
	 * 根据key删除OSS服务器上的文件
	 * 
	 * @param key
	 *            Bucket下的文件的路径名+文件名 如:"upload/cake.jpg" "http://" + BACKET_NAME +
	 *            "." + ENDPOINT + "/" + FOLDER + secondaryFolderName + "/" +
	 *            fileNameNew
	 */
	public static boolean deleteFile(String key) {
		OSSClient ossClient = getOSSClient();
		try {
			// 将图片路径前缀去除
			String pathPrefix = "https://" + BACKET_NAME + "." + ENDPOINT + "/";
			String filePath = key.startsWith(pathPrefix) ? key.substring(pathPrefix.length(), key.length()) : key;
			ossClient.deleteObject(BACKET_NAME, filePath);
			return true;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		} finally {
			ossClient.shutdown();
		}
	}

	/**
	 * 上传图片至OSS
	 * 
	 * @param file
	 * @param secondaryFolderName
	 *            二级文件夹目录
	 * @return
	 */
	public static String uploadObject2OSS(File file, String secondaryFolderName) {
		OSSClient ossClient = getOSSClient();
		try {
			// 以输入流的形式上传文件
			InputStream is = new FileInputStream(file);
			String path = file.getName();
			String fileName = path.substring(path.lastIndexOf("//") + 1);
			String type = path.substring(path.lastIndexOf(".") + 1);
			int random = (int) (Math.random() * 900) + 10000;
			// 文件名
			String fileNameNew = fileName.replace(fileName,
					String.valueOf(System.currentTimeMillis()) + String.valueOf(random) + "." + type);
			// 文件大小
			Long fileSize = file.length();
			// 创建上传Object的Metadata
			ObjectMetadata metadata = new ObjectMetadata();
			// 上传的文件的长度
			metadata.setContentLength(is.available());
			// 指定该Object被下载时的网页的缓存行为
			metadata.setCacheControl("no-cache");
			// 指定该Object下设置Header
			metadata.setHeader("Pragma", "no-cache");
			// 指定该Object被下载时的内容编码格式
			metadata.setContentEncoding("utf-8");
			// 文件的MIME,定义文件的类型及网页编码,决定浏览器将以什么形式、什么编码读取文件。如果用户没有指定则根据Key或文件名的扩展名生成,
			// 如果没有扩展名则填默认值application/octet-stream
			metadata.setContentType(getContentType(fileNameNew));
			// 指定该Object被下载时的名称(指示MINME用户代理如何显示附加的文件,打开或下载,及文件名称)
			metadata.setContentDisposition("filename/filesize=" + fileNameNew + "/" + fileSize + "Byte.");
			//System.out.println(FOLDER + fileNameNew);
			// 上传文件 (上传文件流的形式)
			PutObjectResult putResult = ossClient.putObject(BACKET_NAME,
					FOLDER + secondaryFolderName + "/" + fileNameNew, is, metadata);
			// 解析结果
			URL url = getUrl(ossClient, putResult.getETag());
			return "https://" + BACKET_NAME + "." + ENDPOINT + "/" + FOLDER + secondaryFolderName + "/" + fileNameNew;
		} catch (Exception e) {
			e.printStackTrace();
			return "error";
		} finally {
			ossClient.shutdown();
		}
		// return url;
	}



	/**
	 * 通过文件名判断并获取OSS服务文件上传时文件的contentType
	 * 
	 * @param fileName
	 * @return
	 */
	public static String getContentType(String fileName) {
		// 文件的后缀名
		String fileExtension = fileName.substring(fileName.lastIndexOf("."));
		if (".bmp".equalsIgnoreCase(fileExtension)) {
			return "image/bmp";
		}
		if (".gif".equalsIgnoreCase(fileExtension)) {
			return "image/gif";
		}
		if (".jpeg".equalsIgnoreCase(fileExtension) || ".jpg".equalsIgnoreCase(fileExtension)
				|| ".png".equalsIgnoreCase(fileExtension)) {
			return "image/jpeg";
		}
		if (".html".equalsIgnoreCase(fileExtension)) {
			return "text/html";
		}
		if (".txt".equalsIgnoreCase(fileExtension)) {
			return "text/plain";
		}
		if (".vsd".equalsIgnoreCase(fileExtension)) {
			return "application/vnd.visio";
		}
		if (".ppt".equalsIgnoreCase(fileExtension) || "pptx".equalsIgnoreCase(fileExtension)) {
			return "application/vnd.ms-powerpoint";
		}
		if (".doc".equalsIgnoreCase(fileExtension) || "docx".equalsIgnoreCase(fileExtension)) {
			return "application/msword";
		}
		if (".xml".equalsIgnoreCase(fileExtension)) {
			return "text/xml";
		}
		// 默认返回类型
		return "image/jpeg";
	}

	/**
	 * 
	 * @param ossClient
	 * @param key
	 * @return
	 */
	public static URL getUrl(OSSClient ossClient, String key) {
		// 设置URL过期时间为10年
		Date expiration = new Date(new Date().getTime() + 3600l * 1000 * 24 * 365 * 10);
		// 生成URL
		URL url = ossClient.generatePresignedUrl(BACKET_NAME, key, expiration);
		return url;
	}

	/**
	 * MultipartFile 形式上传文件
	 * @param file
	 * @return
	 * @throws Exception
	 */
	public static String upload(MultipartFile file) throws Exception {
		String fileName = file.getOriginalFilename();
		String prefix = fileName.substring(fileName.lastIndexOf("."));
		final File realfile = File.createTempFile(IdUtil.createIdbyUUID(), prefix);
		file.transferTo(realfile);
		String url = OssUtil.uploadObject2OSS(realfile, "");
		//System.out.println(url);
		return url;
	}
	/**
	 * MultipartFile 形式上传文件
	 * @param file
	 * @return
	 * @throws Exception
	 */
	public static String upload(MultipartFile file, String secondaryFolderName) throws Exception {
		String fileName = file.getOriginalFilename();
		String prefix = fileName.substring(fileName.lastIndexOf("."));
		final File realfile = File.createTempFile(IdUtil.createIdbyUUID(), prefix);
		file.transferTo(realfile);
		String url = OssUtil.uploadObject2OSS(realfile, secondaryFolderName);
		//System.out.println(url);
		return url;
	}
	/**
	 * MultipartFile 形式上传文件
	 * @param file
	 * @return
	 * @throws Exception
	 */
	public static String upload(MultipartFile file, String fileName, String secondaryFolderName) throws Exception {
		String prefix = fileName.substring( fileName.lastIndexOf( "." ) ).toLowerCase();
		final File realfile = File.createTempFile(fileName, prefix);
		file.transferTo(realfile);
		String url = OssUtil.uploadObject2OSS(realfile, secondaryFolderName);
		//System.out.println(url);
		return url;
	}

	/**
	 * MultipartFile 形式上传文件
	 * @param realfile
	 * @return
	 * @throws Exception
	 */
	public static String upload(File realfile,String secondaryFolderName)  {
		String url = OssUtil.uploadObject2OSS(realfile, secondaryFolderName);
		return url;
	}


	/**
	 * 以byte数组上传到oss
	 * @param fbytes				byte数组
	 * @param fileName				文件名称
	 * @param secondaryFolderName	二级文件夹目录
	 * @return
	 * @throws Exception
	 */
	public static String upload(byte[] fbytes,String fileName,String secondaryFolderName) throws Exception {
		OSSClient ossClient = getOSSClient();
//		String fileNameNew = "1.jpg";
		// 上传Byte数组。
		PutObjectResult putResult = ossClient.putObject(BACKET_NAME, FOLDER + secondaryFolderName + "/" + fileName, new ByteArrayInputStream(fbytes));

		// 解析结果
		URL url = getUrl(ossClient, putResult.getETag());
//		System.out.println(url);
		// 关闭OSSClient。
		ossClient.shutdown();
		return "https://" + BACKET_NAME + "." + ENDPOINT + "/" + FOLDER + secondaryFolderName + "/" + fileName;
	}

	/**
	 * 将文件转换成byte数组
	 * @param tradeFile
	 * @return
	 */
	public static byte[] File2byte(File tradeFile){
		byte[] buffer = null;
		try
		{
			FileInputStream fis = new FileInputStream(tradeFile);
			ByteArrayOutputStream bos = new ByteArrayOutputStream();
			byte[] b = new byte[1024];
			int n;
			while ((n = fis.read(b)) != -1)
			{
				bos.write(b, 0, n);
			}
			fis.close();
			bos.close();
			buffer = bos.toByteArray();
		}catch (FileNotFoundException e){
			e.printStackTrace();
		}catch (IOException e){
			e.printStackTrace();
		}
		return buffer;
	}

	public static void main(String [] args) throws Exception {
		boolean flag = deleteFile("http://guangzhou-douli.oss-cn-shenzhen.aliyuncs.com/shouli/qcrod/2.jpg");
		//System.out.println(flag);

		File file = new File("C:\\Users\\yangshanlin\\Desktop\\bg-sfxt.jpg");
		byte[] b = File2byte(file);
		//System.out.println(b);

		String s = upload(b,"3.jpg","qcrod");
		//System.out.println(s);
	}

	public static State uploadToAliOss(byte[] data, String fileName, String secondaryFolderName) throws Exception {
		String path=upload(data,fileName,secondaryFolderName);
		State state = new BaseState(true, path);
		state.putInfo("size", data.length);
		state.putInfo("title",fileName);
		state.putInfo("url",path);
		return state;
	}

	public static State uploadFileToAliOss(File realfile, String secondaryFolderName) {
		String url = OssUtil.uploadObject2OSS(realfile, secondaryFolderName);
		State state = new BaseState(true, url);
		state.putInfo("title",realfile.getName());
		state.putInfo("url",url);
		return state;
	}
}
