package com.example.afrishop_v3.util;

import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

/**
 * @Auther: wudepeng
 * @Date: 2021/03/18
 * @Description:日期处理
 */
public class DateUtil {

    /**
     * 获取南非时区
     *
     * @return
     * @throws ParseException
     */
    public static Date getNow() {
        ZonedDateTime zonedDatetimeFromZone = ZonedDateTime.now(ZoneId.of("Africa/Johannesburg"));
        DateTimeFormatter dateToStrFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String dateStr = dateToStrFormatter.format(zonedDatetimeFromZone);
        TemporalAccessor parse = dateToStrFormatter.parse(dateStr);
        LocalDateTime date = LocalDateTime.from(parse);
        Date now = asDate(date);
        return now;
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }
}
