package com.example.afrishop_v3.thread;

import com.example.afrishop_v3.bo.TencentWordsegParam;
import com.example.afrishop_v3.config.DomainProperties;
import com.example.afrishop_v3.util.IdUtil;
import com.example.afrishop_v3.util.SpringContextUtil;

import java.util.Map;

/** 腾讯分词类
 * https://api.ai.qq.com/fcgi-bin/nlp/nlp_wordpos
 * */
public class WordposCallable extends AbstractTencentCallable<TencentWordsegParam>{

    //private static Logger logger = LoggerFactory.getLogger(WordposCallable.class);
    private static DomainProperties domainProperties = (DomainProperties) SpringContextUtil.getBean("domainProperties");

    public WordposCallable(TencentWordsegParam param) {
        this.app_id = Integer.valueOf(domainProperties.getProperty("tencent.translate.app_id"));
        this.app_url = domainProperties.getProperty("tencent.wordpos.app_url");
        this.param = param;
        this.charset="GBK";
    }

    @Override
    public Map<String, Object> call() throws Exception {
        //logger.info("call()方法被自动调用！！！    " + Thread.currentThread().getName());
        //填充参数
        fillParam(param);
        Map<String, Object> resultMap = super.call();
        return resultMap;
    }

    /**
     * 填充翻译时参数
     *
     * @param param
     */
    @Override
    void fillParam(TencentWordsegParam param) {
        if (param.getApp_id() == null) {
            param.setApp_id(this.app_id);
        }
        if (param.getNonce_str() == null) {
            String randomLetters = IdUtil.createIdbyUUID();
            param.setNonce_str(randomLetters);
        }
        if (param.getTime_stamp() == null) {
            long currentTime = System.currentTimeMillis() / 1000;
            param.setTime_stamp(currentTime);
        }
    }
}
