package com.example.afrishop_v3.service;

import net.sf.json.JSONObject;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

public interface SpiderService {
    /**
     * 爬取数据获取商品详情
     * @param targetUrl
     * @return
     */
    JSONObject getItemDetail(String targetUrl) throws InterruptedException, IOException, ExecutionException, URISyntaxException, TimeoutException;


    /**
     * 获取汇率
     * @param currency FOREXUSDCNY 人民币换美元
     * @return
     */
    BigDecimal getExchangeRate(String currency) throws IOException, URISyntaxException;
}
