package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.TbCfItemCollection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.transaction.annotation.Transactional;


import java.util.Collection;
import java.util.List;

public interface TbCfItemCollectionRepository extends PagingAndSortingRepository<TbCfItemCollection,String> {
    boolean existsByUserIdAndItemItemId(String userId, String itemId);
    Page<TbCfItemCollection> findAllByUserIdOrderByCreateTimeDesc(String userId, Pageable pageable);


    @Transactional
    void deleteAllByItemItemIdInAndUserId(String[] ids, String userId);
}
