package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.TbCfExpressTemplate;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;

import java.util.List;
import java.util.Optional;

public interface TbCfExpressTemplateRepository extends PagingAndSortingRepository<TbCfExpressTemplate,String> {
    @Query(value = "select distinct t2 from TbCfExpTemKeyword t1 left join #{#entityName} t2  on t1.templateId=t2.templateId" +
            "     where t1.keyword LIKE concat('%',:keyword,'%') or t1.enkeyword  LIKE concat('%',:keyword,'%')")
    List<TbCfExpressTemplate> getTemplateByKeyword(@Param("keyword") String keyword);

    Optional<TbCfExpressTemplate> findFirstByIsDefault(Integer isDefault);
}

