package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.PostHashtag;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface PostHashtagRepository extends PagingAndSortingRepository<PostHashtag,String> {

    boolean existsByHashtagNameAndPostId(String hashtag_name, String post_id);


    @Query(value = "delete c from post_hashtag_v2 c WHERE c.post_id=:post",nativeQuery = true)
    @Modifying
    @Transactional
    void removeByPost_Id(@Param("post") String post_id);
}
