package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.Network;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.PagingAndSortingRepository;

import java.util.Optional;

public interface NetworkRepository extends PagingAndSortingRepository<Network,String> {
    boolean existsByUserInfo_UserIdAndNetworkInfo_UserId(String userInfo_userId, String networkInfo_userId);
    boolean existsByUserInfo_CodeAndNetworkInfo_UserId(String userInfo_code, String networkInfo_userId);
    Network findByUserInfo_UserIdAndNetworkInfo_UserId(String user, String network);
    Network findByUserInfo_CodeAndNetworkInfo_UserId(String userInfo_code, String networkInfo_userId);
    Optional<Network> findFirstByNetworkInfoCode(String user_code);

    Network findTopByOrderByIdDesc();

    Page<Network> findAllByUserInfo_UserIdOrderByIdDesc(String userInfo_userId, Pageable pageable);
}
