package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.PostLike;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface LikeRepository  extends PagingAndSortingRepository<PostLike, String> {
    Page<PostLike> findAllByPost_Id(String postId, Pageable pageable);

    @Query(value = "delete from post_like_v2 WHERE user_info_user_id=:userId and post_id=:post",nativeQuery = true)
    @Modifying
    @Transactional
    void removeByUser_IdAndPost_Id(@Param("userId") String user_id, @Param("post") String post_id);

    @Query(value = "delete from post_like_v2 WHERE post_id=:post",nativeQuery = true)
    @Modifying
    @Transactional
    void removeByPost_Id(@Param("post") String post_id);
    boolean existsByUserInfo_UserIdAndPost_Id(String userInfo_userId, String post_id);
}
