package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.Comment;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

public interface CommentRepository extends PagingAndSortingRepository<Comment, String> {
    Page<Comment> findAllByPostId(String post_id, Pageable pageable);

    @Query(value = "delete from comment WHERE post_id=:post",nativeQuery = true)
    @Modifying
    @Transactional
    void removeByPost_Id(@Param("post") String post_id);
}
