package com.example.afrishop_v3.repository;

import com.example.afrishop_v3.models.Activity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.relational.core.sql.In;

import javax.annotation.Nullable;
import java.util.List;
import java.util.Optional;

/**
 * @Auther: wudepeng
 * @Date: 2020/12/02
 * @Description:
 */
public interface ActivityRepository extends JpaRepository<Activity, String> {

    @Query(value = "select a from Activity a where CURRENT_TIMESTAMP between startTime and endTime and status=1 order by a.createTime desc")
    Page<Activity> getAllActivity(Pageable pageable);


    boolean existsByUseType(Integer useType);

//    @Query(value = "select * from Activity a where CURRENT_TIMESTAMP between a.start_time and a.end_time and a.status=1 and use_type=:useType order by a.create_time desc limit 1", nativeQuery = true)
//    Optional<Activity> findFirstByUseType(Integer useType);

    @Query(value = "select * from Activity a where CURRENT_TIMESTAMP between a.start_time and a.end_time and a.status=1 and a.use_type=:useType order by a.create_time desc ", nativeQuery = true)
    List<Activity> findAllByUseType(Integer useType);


    boolean existsByStatus(Integer status);

}
