package com.example.afrishop_v3.quartz;


import com.example.afrishop_v3.models.Token;
import com.example.afrishop_v3.repository.TbCfExchangeRepository;
import com.example.afrishop_v3.repository.TokenRepository;
import com.example.afrishop_v3.repository.UserRepository;
import com.example.afrishop_v3.util.HttpClientUtil;
import com.example.afrishop_v3.util.IdUtil;
import com.example.afrishop_v3.util.PayPalUtil;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.Optional;


@Component
public class QuartzMethod {
    private final UserRepository userRepository;

    @Value("${paypal.mode}")
    private String mode;

    private final TbCfExchangeRepository exchangeRepository;
    private final TokenRepository tokenRepository;

    public QuartzMethod(UserRepository userRepository, @Qualifier("tbCfExchangeRepository") TbCfExchangeRepository exchangeRepository, TokenRepository tokenRepository) {
        this.userRepository = userRepository;
        this.exchangeRepository = exchangeRepository;
        this.tokenRepository = tokenRepository;
    }

//    //@Scheduled(cron = "0 0/1 * * * ? ")
//    public  void sendEmail() throws EmailException, TemplateException, IOException {
//        System.out.println("////////////////////////////////////////////////////");
//      String email= tbCfUserInfoService.findEmails();
//      //  String email= "1203063316@qq.com";
//        if(email!=null){
//            String s = tbCfUserInfoService.sendRegister(email);
//            if(s!=null){
//                System.out.println("已发送邮件:"+email);
//            }
//        }
//    }

    /**
     * 美元-克瓦查
     *
     * @throws IOException
     * @throws URISyntaxException
     */
    @Scheduled(cron = "0 0 3 * * ?")
    public void getRent() throws IOException, URISyntaxException {
        String content = HttpClientUtil.getContentByUrl("https://cn.valutafx.com/USD-ZMW.htm?amount=1", "rent");
        // 解析为 Document 对象
        Document document = Jsoup.parse(content);
        String rent = document.select("div[class=rate-value]").text();
        BigDecimal rate = new BigDecimal(rent);
        String type = "USD-ZMW";
        exchangeRepository.updateByType(type, rate);
    }

    /**
     * 美元-人民币
     *
     * @throws IOException
     * @throws URISyntaxException
     */
    @Scheduled(cron = "0 0 3 * * ?")
    public void getRate() throws IOException, URISyntaxException {
        String content = HttpClientUtil.getContentByUrl("https://cn.valutafx.com/USD-CNY.htm?amount=1", "rent");
        // 解析为 Document 对象
        Document document = Jsoup.parse(content);
        String rent = document.select("div[class=rate-value]").text();
        BigDecimal rate = new BigDecimal(rent);
        String type = "USD-CNY";
        exchangeRepository.updateByType(type, rate);
    }

    @Scheduled(cron = "0 0 0/2 * * ?")
    public void getToken() throws IOException {
        Optional<Token> firstToken = tokenRepository.findFirstToken();
        String oldToken = firstToken.get().getToken();
        String token = PayPalUtil.getToken(oldToken, mode);
        if (oldToken.equals(token)) {
            getToken();
        }
        if (!tokenRepository.existsByToken(token)) {
            Token t = new Token();
            t.setId(IdUtil.createIdbyUUID());
            t.setToken(token);
            t.setCreateTime(new Date());
            tokenRepository.save(t);
        }
    }
}
