package com.example.afrishop_v3.models;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * 实体
 * 表名 term
 *
 * @author lipengjun
 * @date 2020-10-27 17:49:26
 */
@Entity
public class Term implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 条款ID
     */
    @Id
    private String id;
    /**
     * 父条款ID，一级条款为0
     */
    private String parentId;
    /**
     * 条款名称
     */
    private String termName;

    /**
     * 条款内容
     */
    private String termContent;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 状态   0：无效   1：有效
     */
    private Integer status;
    /**
     * 排序
     */
    private Integer sort;



    /**
     * 设置：条款ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取：条款ID
     */
    public String getId() {
        return id;
    }
    /**
     * 设置：父条款ID，一级条款为0
     */
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    /**
     * 获取：父条款ID，一级条款为0
     */
    public String getParentId() {
        return parentId;
    }
    /**
     * 设置：条款名称
     */
    public void setTermName(String termName) {
        this.termName = termName;
    }

    /**
     * 获取：条款名称
     */
    public String getTermName() {
        return termName;
    }
    /**
     * 设置：条款内容
     */
    public void setTermContent(String termContent) {
        this.termContent = termContent;
    }

    /**
     * 获取：条款内容
     */
    public String getTermContent() {
        return termContent;
    }
    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }
    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }
    /**
     * 设置：状态   0：无效   1：有效
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取：状态   0：无效   1：有效
     */
    public Integer getStatus() {
        return status;
    }
    /**
     * 设置：排序
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    /**
     * 获取：排序
     */
    public Integer getSort() {
        return sort;
    }


}
