package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 实体
 * 表名 tb_cf_toicoupon
 *
 * @author lipengjun
 * @date 2019-11-22 19:32:08
 */
@Entity
@Data
public class TbCfToicoupon {

    /**
     * 发放/领取表id
     */
    @Id
    private String toitableId;
    /**
     * 优惠券id
     */
    @ManyToOne()
    @JsonIgnore
    @JoinColumn(columnDefinition = "coupon_id",name = "coupon_id")
    private TbCfCoupon coupon;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 开始时间
     */
    private Date startTime;
    /**
     * 结束时间
     */
    private Date endTime;
    /**
     * 标识(1发放，2领取，3注册)
     */
    private Integer identification;
    /**
     * 是否已使用(0已使用，1未使用)
     */
    private Integer enableFlag;

    /**
     * 设置：发放/领取表id
     */
    public void setToitableId(String toitableId) {
        this.toitableId = toitableId;
    }

    @JsonProperty
    public String couponTitle(){
        return coupon == null ? "" : coupon.getCouponTitle();
    }

    @JsonProperty
    public BigDecimal withAmount(){
        return coupon == null ? BigDecimal.ZERO : coupon.getWithAmount();
    }

    @JsonProperty
    public BigDecimal deductAmount(){
        return coupon == null ? BigDecimal.ZERO : coupon.getDeductAmount();
    }

    @JsonProperty
    public Date validStartTime(){
        return startTime;
    }

    @JsonProperty
    public Date validEndTime(){
        return endTime;
    }

    @JsonProperty
    public String couponCategoryName(){
        return coupon == null ? "" : coupon.getCouponCategoryName();
    }


    @JsonProperty
    public Integer couponVaild(){
        return coupon == null ? 0 : coupon.getCouponVaild();
    }


    @JsonProperty
    public String couponId(){
        return coupon == null ? "" : coupon.getCouponId();
    }

    /**
     * 获取：发放/领取表id
     */
    public String getToitableId() {
        return toitableId;
    }
    /**
     * 设置：优惠券id
     */

    public void setCoupon(TbCfCoupon coupon) {
        this.coupon = coupon;
    }
    /**
     * 设置：用户id
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取：用户id
     */
    public String getUserId() {
        return userId;
    }
    /**
     * 设置：开始时间
     */
    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    /**
     * 获取：开始时间
     */
    public Date getStartTime() {
        return startTime;
    }
    /**
     * 设置：结束时间
     */
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    /**
     * 获取：结束时间
     */
    public Date getEndTime() {
        return endTime;
    }
    /**
     * 设置：标识(1发放，2领取，3注册)
     */
    public void setIdentification(Integer identification) {
        this.identification = identification;
    }

    /**
     * 获取：标识(1发放，2领取，3注册)
     */
    public Integer getIdentification() {
        return identification;
    }
    /**
     * 设置：是否已使用(0已使用，1未使用)
     */
    public void setEnableFlag(Integer enableFlag) {
        this.enableFlag = enableFlag;
    }

    /**
     * 获取：是否已使用(0已使用，1未使用)
     */
    public Integer getEnableFlag() {
        return enableFlag;
    }


    public TbCfCoupon getCoupon() {
        return coupon;
    }
}
