package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 第三方平台对应订单信息实体
 * 表名 tb_cf_platform_order
 *
 * @author lipengjun
 * @date 2020-06-05 11:22:12
 */
@Entity
@Data
public class TbCfPlatformOrder {

    /**
     * 对应id
     */
    @Id
    private String relativeId;
    /**
     * 订单id
     */
    private String orderId;
    /**
     * 第三方订单id
     */
    private String pOrderId;
    /**
     * 商品ID
     */
    private String itemId;
    /**
     * 第三方平台名
     */
    private String platformName;
    /**
     * 第三方平台编号
     */
    private String platformCode;
    /**
     * 第三方发货地址
     */
    private String pDeliveryAddress;
    /**
     * 代购人
     */
    private String userName;
    /**
     * 代购人id
     */
    private String userId;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 实际付款
     */
    private BigDecimal realityPay;
    /**
     * 第三方快递单号
     */
    private String pExpressNumber;
    /**
     * 商品品名id
     */
    private String descripitionId;
    /**
     * 物流状态 10：无 20：有
     */
    private Integer logisticsStatus;

//    @JsonIgnore @JoinColumn(columnDefinition = "order_id",name = "order_id")
//    @ManyToOne(fetch = FetchType.LAZY)
//    private TbCfOrder order;

    /**
     * 设置：对应id
     */
    public void setRelativeId(String relativeId) {
        this.relativeId = relativeId;
    }

    /**
     * 获取：对应id
     */
    public String getRelativeId() {
        return relativeId;
    }
    /**
     * 设置：订单id
     */
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }




    /**
     * 获取：订单id
     */
    public String getOrderId() {
        return orderId;
    }
    /**
     * 设置：第三方订单id
     */
    public void setPOrderId(String pOrderId) {
        this.pOrderId = pOrderId;
    }

    /**
     * 获取：第三方订单id
     */
    public String getPOrderId() {
        return pOrderId;
    }
    /**
     * 设置：商品ID
     */
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    /**
     * 获取：商品ID
     */
    public String getItemId() {
        return itemId;
    }
    /**
     * 设置：第三方平台名
     */
    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    /**
     * 获取：第三方平台名
     */
    public String getPlatformName() {
        return platformName;
    }
    /**
     * 设置：第三方平台编号
     */
    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    /**
     * 获取：第三方平台编号
     */
    public String getPlatformCode() {
        return platformCode;
    }
    /**
     * 设置：第三方发货地址
     */
    public void setPDeliveryAddress(String pDeliveryAddress) {
        this.pDeliveryAddress = pDeliveryAddress;
    }

    /**
     * 获取：第三方发货地址
     */
    public String getPDeliveryAddress() {
        return pDeliveryAddress;
    }
    /**
     * 设置：代购人
     */
    public void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * 获取：代购人
     */
    public String getUserName() {
        return userName;
    }
    /**
     * 设置：代购人id
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    /**
     * 获取：代购人id
     */
    public String getUserId() {
        return userId;
    }
    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }
    /**
     * 设置：实际付款
     */
    public void setRealityPay(BigDecimal realityPay) {
        this.realityPay = realityPay;
    }

    /**
     * 获取：实际付款
     */
    public BigDecimal getRealityPay() {
        return realityPay;
    }
    /**
     * 设置：第三方快递单号
     */
    public void setPExpressNumber(String pExpressNumber) {
        this.pExpressNumber = pExpressNumber;
    }

    /**
     * 获取：第三方快递单号
     */
    public String getPExpressNumber() {
        return pExpressNumber;
    }
    /**
     * 设置：商品品名id
     */
    public void setDescripitionId(String descripitionId) {
        this.descripitionId = descripitionId;
    }

    /**
     * 获取：商品品名id
     */
    public String getDescripitionId() {
        return descripitionId;
    }
    /**
     * 设置：物流状态 10：无 20：有
     */
    public void setLogisticsStatus(Integer logisticsStatus) {
        this.logisticsStatus = logisticsStatus;
    }

    /**
     * 获取：物流状态 10：无 20：有
     */
    public Integer getLogisticsStatus() {
        return logisticsStatus;
    }
}
