package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 商品规格表实体
 * 表名 tb_cf_item_skus
 *
 * @author lipengjun
 * @date 2020-04-10 14:23:43
 */
@Entity
@Data
public class TbCfItemSkus{

    /**
     * 商品规格ID
     */
    @Id
    private String id;
    /**
     * 商品ID
     */
    private String itemId;
    /**
     * 规格名称
     */
    private String skuName;
    /**
     * 商品规格图片
     */
    private String skuImg;
    /**
     * 商品规格编码
     */
    private String skuCode;
    /**
     * 规格描述
     */
    private String skuDesc;
    /**
     * 价格
     */
    @JsonProperty(value = "price")
    private BigDecimal skuPrice;
    /**
     * 属性IDS
     */
    private String optionIds;
    /**
     * 数量
     */
    @JsonProperty(value = "count")
    private Integer skuCount;
    /**
     * 排序号
     */
    private Integer orderNum;
    /**
     * 删除标记
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    @JsonProperty
    public List<SkuDetail> skus(){
        String[] split = skuName.split("/");
        String[] split2 = skuDesc.split("/");
        int index = 0;
        List<SkuDetail> detailList = new ArrayList<>();
        for (String s : split){
            if( index > split2.length ) break;
            detailList.add(new SkuDetail(s.trim(),split2[index].trim()));
            index++;
        }
        return detailList;
    }

    /**
     * 设置：商品规格ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取：商品规格ID
     */
    public String getId() {
        return id;
    }
    /**
     * 设置：商品ID
     */
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    /**
     * 获取：商品ID
     */
    public String getItemId() {
        return itemId;
    }
    /**
     * 设置：规格名称
     */
    public void setSkuName(String skuName) {
        this.skuName = skuName;
    }

    /**
     * 获取：规格名称
     */
    public String getSkuName() {
        return skuName;
    }
    /**
     * 设置：商品规格图片
     */
    public void setSkuImg(String skuImg) {
        this.skuImg = skuImg;
    }

    /**
     * 获取：商品规格图片
     */
    public String getSkuImg() {
        return skuImg;
    }
    /**
     * 设置：商品规格编码
     */
    public void setSkuCode(String skuCode) {
        this.skuCode = skuCode;
    }

    /**
     * 获取：商品规格编码
     */
    public String getSkuCode() {
        return skuCode;
    }
    /**
     * 设置：规格描述
     */
    public void setSkuDesc(String skuDesc) {
        this.skuDesc = skuDesc;
    }

    /**
     * 获取：规格描述
     */
    public String getSkuDesc() {
        return skuDesc;
    }
    /**
     * 设置：价格
     */
    public void setSkuPrice(BigDecimal skuPrice) {
        this.skuPrice = skuPrice;
    }

    /**
     * 获取：价格
     */
    public BigDecimal getSkuPrice() {
        return skuPrice;
    }
    /**
     * 设置：属性IDS
     */
    public void setOptionIds(String optionIds) {
        this.optionIds = optionIds;
    }

    /**
     * 获取：属性IDS
     */
    public String getOptionIds() {
        return optionIds;
    }
    /**
     * 设置：数量
     */
    public void setSkuCount(Integer skuCount) {
        this.skuCount = skuCount;
    }

    /**
     * 获取：数量
     */
    public Integer getSkuCount() {
        return skuCount;
    }
    /**
     * 设置：排序号
     */
    public void setOrderNum(Integer orderNum) {
        this.orderNum = orderNum;
    }

    /**
     * 获取：排序号
     */
    public Integer getOrderNum() {
        return orderNum;
    }
    /**
     * 设置：删除标记
     */
    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    /**
     * 获取：删除标记
     */
    public Integer getDelFlag() {
        return delFlag;
    }
    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }
    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }
}
