package com.example.afrishop_v3.models;

import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * 实体
 * 表名 tb_cf_item_desc
 *
 * @author lipengjun
 * @date 2019-12-23 14:28:47
 */
@Entity
@Data
public class TbCfItemDesc {

    /**
     * 商品ID
     */
    @Id
    private String itemId;
    /**
     * 商品描述
     */
    private String itemDesc;
    /**
     * 删除标志
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 设置：商品ID
     */
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    /**
     * 获取：商品ID
     */
    public String getItemId() {
        return itemId == null ? "" : itemId;
    }

    /**
     * 设置：商品描述
     */
    public void setItemDesc(String itemDesc) {
        this.itemDesc = itemDesc;
    }

    /**
     * 获取：商品描述
     */
    public String getItemDesc() {
        return itemDesc == null ? "" : itemDesc;
    }

    /**
     * 设置：删除标志
     */
    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    /**
     * 获取：删除标志
     */
    public Integer getDelFlag() {
        return delFlag == null ? 0 : delFlag;
    }

    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime == null ? new Date() : createTime;
    }

    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime == null ? new Date() : updateTime;
    }

}
