package com.example.afrishop_v3.models;

import lombok.Data;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import java.util.Date;

/**
 * 实体
 * 表名 tb_cf_item_collection
 *
 * @author lipengjun
 * @date 2019-12-31 12:09:48
 */
@Entity
@Data
public class TbCfItemCollection {

    /**
     * ID
     */
    @Id
    private String id;
    /**
     * 用户
     */
    private String userId;
    /**
     * 商品
     */
    //private String itemId;

    @ManyToOne
    @JoinColumn(columnDefinition = "item_id",name = "item_id")
    @NotFound(action= NotFoundAction.IGNORE)
    private TbCfStationItem item;
    /**
     * 删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 设置：ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取：ID
     */
    public String getId() {
        return id;
    }
    /**
     * 设置：用户
     */
    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setItem(TbCfStationItem item) {
        this.item = item;
    }

    /**
     * 获取：用户
     */
    public String getUserId() {
        return userId;
    }
//    /**
//     * 设置：商品
//     */
//    public void setItemId(String itemId) {
//        this.itemId = itemId;
//    }
//
//    /**
//     * 获取：商品
//     */
//    public String getItemId() {
//        return itemId;
//    }
    /**
     * 设置：删除
     */
    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    /**
     * 获取：删除
     */
    public Integer getDelFlag() {
        return delFlag;
    }
    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }
    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }
}
