package com.example.afrishop_v3.models;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;

/**
 * 商品一级分类表实体
 * 表名 tb_cf_goodstype
 *
 * @author lipengjun
 * @date 2020-03-31 17:04:36
 */
@Entity
@Setter
@Getter
public class TbCfGoodstype{

    /**
     * 商品分类Id
     */
    @Id
    private String goodstypeId;
    /**
     * 商品分类标题
     */
    private String goodstypeTitle;
    /**
     * 商品分类排序编号
     */
    private Integer goodstypeSort;
    /**
     * 分类详情（旧版）
     */
    private String goodstypeUrl;
    /**
     * 分类图片
     */
    private String goodstypeImage;

    /**
     * 设置：商品分类Id
     */
    public void setGoodstypeId(String goodstypeId) {
        this.goodstypeId = goodstypeId;
    }

    /**
     * 获取：商品分类Id
     */
    public String getGoodstypeId() {
        return goodstypeId;
    }
    /**
     * 设置：商品分类标题
     */
    public void setGoodstypeTitle(String goodstypeTitle) {
        this.goodstypeTitle = goodstypeTitle;
    }

    /**
     * 获取：商品分类标题
     */
    public String getGoodstypeTitle() {
        return goodstypeTitle;
    }
    /**
     * 设置：商品分类排序编号
     */
    public void setGoodstypeSort(Integer goodstypeSort) {
        this.goodstypeSort = goodstypeSort;
    }

    /**
     * 获取：商品分类排序编号
     */
    public Integer getGoodstypeSort() {
        return goodstypeSort;
    }
    /**
     * 设置：分类详情（旧版）
     */
    public void setGoodstypeUrl(String goodstypeUrl) {
        this.goodstypeUrl = goodstypeUrl;
    }

    /**
     * 获取：分类详情（旧版）
     */
    public String getGoodstypeUrl() {
        return goodstypeUrl;
    }
    /**
     * 设置：分类图片
     */
    public void setGoodstypeImage(String goodstypeImage) {
        this.goodstypeImage = goodstypeImage;
    }

    /**
     * 获取：分类图片
     */
    public String getGoodstypeImage() {
        return goodstypeImage;
    }
}
