package com.example.afrishop_v3.models;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 商品二级分类表实体
 * 表名 tb_cf_goodstwotype
 *
 * @author lipengjun
 * @date 2020-03-05 13:29:28
 */
@Entity
@Setter
@Getter
public class TbCfGoodstwotype{

    /**
     * 商品二级分类Id
     */
    @Id
    private String goodstwotypeId;
    /**
     * 商品二级分类标题
     */
    private String goodstwotypeTitle;
    /**
     * 商品一级分类id
     */
    private String goodstypeId;
    /**
     * 二级分类图片
     */
    private String goodstwotypeUrl;

    @Transient
    private boolean autoLoad = false;

    private Integer sort;

    @OneToMany(mappedBy = "goodstwotypeId")
    private List<TbCfDescripiton> categoryList = new ArrayList<>();

    public Integer getSort() {
        return sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    /**
     * 设置：商品二级分类Id
     */
    public void setGoodstwotypeId(String goodstwotypeId) {
        this.goodstwotypeId = goodstwotypeId;
    }

    /**
     * 获取：商品二级分类Id
     */
    public String getGoodstwotypeId() {
        return goodstwotypeId;
    }

    public void enableAutoLoad(){
        this.autoLoad = true;
    }
    /**
     * 设置：商品二级分类标题
     */
    public void setGoodstwotypeTitle(String goodstwotypeTitle) {
        this.goodstwotypeTitle = goodstwotypeTitle;
    }

    public List<TbCfDescripiton> getCategoryList() {
        return autoLoad ? categoryList : new ArrayList<>();
    }

    /**
     * 获取：商品二级分类标题
     */
    public String getGoodstwotypeTitle() {
        return goodstwotypeTitle;
    }
    /**
     * 设置：商品一级分类id
     */
    public void setGoodstypeId(String goodstypeId) {
        this.goodstypeId = goodstypeId;
    }

    /**
     * 获取：商品一级分类id
     */
    public String getGoodstypeId() {
        return goodstypeId;
    }
    /**
     * 设置：二级分类图片
     */
    public void setGoodstwotypeUrl(String goodstwotypeUrl) {
        this.goodstwotypeUrl = goodstwotypeUrl;
    }

    /**
     * 获取：二级分类图片
     */
    public String getGoodstwotypeUrl() {
        return goodstwotypeUrl;
    }
}
