package com.example.afrishop_v3.models;

import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 汇率管理实体
 * 表名 tb_cf_exchange
 *
 * @author lipengjun
 * @date 2019-12-10 15:29:22
 */
@Entity
@Data
public class TbCfExchange{

    /**
     * ID
     */
    @Id
    private String id;
    /**
     * 转换类型
     */
    private String type;
    /**
     * 货币
     */
    private String currency;
    /**
     * 兑换货币
     */
    private String exchangeCurrency;
    /**
     * 汇率
     */
    private BigDecimal exchangeRate;
    /**
     * 删除标志 0：正常 1：已删除
     */
    private Integer delFlag;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 设置：ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取：ID
     */
    public String getId() {
        return id;
    }
    /**
     * 设置：转换类型
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * 获取：转换类型
     */
    public String getType() {
        return type;
    }
    /**
     * 设置：货币
     */
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /**
     * 获取：货币
     */
    public String getCurrency() {
        return currency;
    }
    /**
     * 设置：兑换货币
     */
    public void setExchangeCurrency(String exchangeCurrency) {
        this.exchangeCurrency = exchangeCurrency;
    }

    /**
     * 获取：兑换货币
     */
    public String getExchangeCurrency() {
        return exchangeCurrency;
    }
    /**
     * 设置：汇率
     */
    public void setExchangeRate(BigDecimal exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    /**
     * 获取：汇率
     */
    public BigDecimal getExchangeRate() {
        return exchangeRate;
    }
    /**
     * 设置：删除标志 0：正常 1：已删除
     */
    public void setDelFlag(Integer delFlag) {
        this.delFlag = delFlag;
    }

    /**
     * 获取：删除标志 0：正常 1：已删除
     */
    public Integer getDelFlag() {
        return delFlag;
    }
    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }
    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }
}
