package com.example.afrishop_v3.models;

import lombok.Data;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 优惠券表实体
 * 表名 tb_cf_coupon
 *
 * @author G
 * @date 2019-08-14 09:11:48
 */
@Entity
@Data
public class TbCfCoupon {
    private String toitableId;
    @Id
    private String couponId;

    private String couponCategoryId;

    private String couponCategoryName;

    private Integer couponUse;

    private String couponTitle;

    private String couponIcon;
    private String withStationId;
    private BigDecimal withAmount;

    private BigDecimal deductAmount;
    /**
     * 发券数量
     */
    private Integer quato;
    /**
     * 已领取数量 不更改，因为会被覆盖，改为查询统计来获取已经领取的优惠券数量
     */
    private Integer takeCount;
    /**
     * 已使用数量 不更改，因为会被覆盖，改为查询统计来获取已经使用的优惠券数量
     */
    private Integer usedCount;
    /**
     * 发放开始时间
     */
    private Date startTime;
    /**
     * 发放结束时间
     */
    private Date endTime;
    /**
     * 有效开始时间
     */
    private Date validStartTime;
    /**
     * 有效结束时间
     */
    private Date validEndTime;
    /**
     * 有效标志,0无效,1生效,2过期
     */
    private Integer status;
    /**
     * 创建人
     */
    private String createUserId;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 修改人
     */
    private String updateUserId;
    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 设置是否是注册就是的优惠券，(0)默认状态，（1）是用户注册就送这张优惠券
     */
    private Integer couponVaild;
    /**
     * 设置：设置是否是注册就是的优惠券，(0)默认状态，（1）是用户注册就送这张优惠券
     */

    public String getToitableId() {
        return toitableId;
    }

    public void setToitableId(String toitableId) {
        this.toitableId = toitableId;
    }

    public String getCouponId() {
        return couponId;
    }

    public void setCouponId(String couponId) {
        this.couponId = couponId;
    }

    public String getCouponCategoryId() {
        return couponCategoryId;
    }

    public void setCouponCategoryId(String couponCategoryId) {
        this.couponCategoryId = couponCategoryId;
    }

    public String getCouponCategoryName() {
        return couponCategoryName;
    }

    public void setCouponCategoryName(String couponCategoryName) {
        this.couponCategoryName = couponCategoryName;
    }

    public Integer getCouponUse() {
        return couponUse;
    }

    public void setCouponUse(Integer couponUse) {
        this.couponUse = couponUse;
    }

    public String getCouponTitle() {
        return couponTitle;
    }

    public void setCouponTitle(String couponTitle) {
        this.couponTitle = couponTitle;
    }

    public String getCouponIcon() {
        return couponIcon;
    }

    public void setCouponIcon(String couponIcon) {
        this.couponIcon = couponIcon;
    }

    public String getWithStationId() {
        return withStationId;
    }

    public void setWithStationId(String withStationId) {
        this.withStationId = withStationId;
    }

    public BigDecimal getWithAmount() {
        return withAmount;
    }

    public void setWithAmount(BigDecimal withAmount) {
        this.withAmount = withAmount;
    }

    public BigDecimal getDeductAmount() {
        return deductAmount;
    }

    public void setDeductAmount(BigDecimal deductAmount) {
        this.deductAmount = deductAmount;
    }

    public Integer getQuato() {
        return quato;
    }

    public void setQuato(Integer quato) {
        this.quato = quato;
    }

    public Integer getTakeCount() {
        return takeCount;
    }

    public void setTakeCount(Integer takeCount) {
        this.takeCount = takeCount;
    }

    public Integer getUsedCount() {
        return usedCount;
    }

    public void setUsedCount(Integer usedCount) {
        this.usedCount = usedCount;
    }

    public Date getStartTime() {
        return startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getValidStartTime() {
        return validStartTime;
    }

    public void setValidStartTime(Date validStartTime) {
        this.validStartTime = validStartTime;
    }

    public Date getValidEndTime() {
        return validEndTime;
    }

    public void setValidEndTime(Date validEndTime) {
        this.validEndTime = validEndTime;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public String getCreateUserId() {
        return createUserId;
    }

    public void setCreateUserId(String createUserId) {
        this.createUserId = createUserId;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdateUserId() {
        return updateUserId;
    }

    public void setUpdateUserId(String updateUserId) {
        this.updateUserId = updateUserId;
    }

    public Date getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Integer getCouponVaild() {
        return couponVaild;
    }

    public void setCouponVaild(Integer couponVaild) {
        this.couponVaild = couponVaild;
    }
}
