package com.example.afrishop_v3.models;

import lombok.Data;
import org.hibernate.annotations.Where;
import org.hibernate.sql.ast.Clause;

import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.io.Serializable;

/**
 * 首页分类导航实体
 * 表名 tb_cf_classification
 *
 * @author lipengjun
 * @date 2020-03-01 14:05:19
 */
@Entity
@Data
public class TbCfClassification {

    /**
     * 首页分类导航ID
     */
    @Id
    private String id;
    /**
     * 一级分类ID
     */
    private String goodtypeId;
    /**
     * 标题
     */
    private String classTitle;
    /**
     * 图片
     */
    private String picture;
    /**
     * 排序
     */
    private Integer sort;
    /**
     * 是否展示
     */
    private String isShow;

    private Integer type;

    private String categoryId;

    @Transient
    private Integer num;

    @Transient
    private boolean isParent;

    /**
     * 设置：首页分类导航ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取：首页分类导航ID
     */
    public String getId() {
        return id;
    }

    /**
     * 设置：一级分类ID
     */
    public void setGoodtypeId(String goodtypeId) {
        this.goodtypeId = goodtypeId;
    }

    /**
     * 获取：一级分类ID
     */
    public String getGoodtypeId() {
        return goodtypeId;
    }

    /**
     * 设置：标题
     */
    public void setClassTitle(String classTitle) {
        this.classTitle = classTitle;
    }

    /**
     * 获取：标题
     */
    public String getClassTitle() {
        return classTitle;
    }

    /**
     * 设置：图片
     */
    public void setPicture(String picture) {
        this.picture = picture;
    }

    /**
     * 获取：图片
     */
    public String getPicture() {
        return picture;
    }

    /**
     * 设置：排序
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    /**
     * 获取：排序
     */
    public Integer getSort() {
        return sort;
    }

    /**
     * 设置：是否展示
     */
    public void setIsShow(String isShow) {
        this.isShow = isShow;
    }

    /**
     * 获取：是否展示
     */
    public String getIsShow() {
        return isShow;
    }
}
