package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Getter
@Setter
@Table(name = "post_like_v2")
public class PostLike extends Model {
    @JsonIgnore
    @ManyToOne(cascade = CascadeType.ALL)
    private Post post;

    @ManyToOne()
    private TbCfUserInfo userInfo;


    public String getPostId() {
        return post == null ? null : post.id;
    }

    public String getUserId() {
        return userInfo == null ? null : userInfo.getUserId();
    }
}
