package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.hibernate.annotations.Where;

import javax.persistence.Entity;
import javax.persistence.Id;
import java.io.Serializable;
import java.util.Date;

/**
 * 实体
 * 表名 country
 *
 * @author lipengjun
 * @date 2021-01-14 08:18:53
 */
@Where(clause = "status=1")
@Entity
public class Country implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 国家ID
     */
    @Id
    private String id;
    /**
     * 国家名称
     */
    private String countryName;
    /**
     * 国家（中文）
     */
    private String countryCname;
    /**
     * 区号
     */
    private String areaCode;
    /**
     * 国旗
     */
    private String nationalFlag;






    /**
     * 设置：国家ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取：国家ID
     */
    public String getId() {
        return id;
    }
    /**
     * 设置：国家名称
     */
    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    /**
     * 获取：国家名称
     */
    public String getCountryName() {
        return countryName;
    }
    /**
     * 设置：国家（中文）
     */
    public void setCountryCname(String countryCname) {
        this.countryCname = countryCname;
    }

    /**
     * 获取：国家（中文）
     */
    public String getCountryCname() {
        return countryCname;
    }
    /**
     * 设置：区号
     */
    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    /**
     * 获取：区号
     */
    public String getAreaCode() {
        return areaCode;
    }
    /**
     * 设置：国旗
     */
    public void setNationalFlag(String nationalFlag) {
        this.nationalFlag = nationalFlag;
    }

    /**
     * 获取：国旗
     */
    public String getNationalFlag() {
        return nationalFlag;
    }

    @Override
    public String toString() {
        return "Country{" +
                "id='" + id + '\'' +
                ", countryName='" + countryName + '\'' +
                ", countryCname='" + countryCname + '\'' +
                ", areaCode='" + areaCode + '\'' +
                ", nationalFlag='" + nationalFlag + '\'' +
                '}';
    }
}
