package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonBackReference;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Entity
@Getter
@Setter
public class Content extends Model {

    @JsonBackReference
    @ManyToOne(cascade = CascadeType.ALL)
    private Post post;



    private String content;
    private String thumbnail;


    private long size;

    private boolean isImage;

    @OneToMany(mappedBy = "content",cascade = CascadeType.ALL)
    public List<ContentTag> contentTags = new ArrayList<>();



    public void setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setImage(boolean image) {
        isImage = image;
    }

    public void setPost(Post post) {
        this.post = post;
    }

    public void setContent(String content) {
        this.content = content;
    }


    public void setSize(long size) {
        this.size = size;
    }



    public String getThumbnail() {
        return thumbnail;
    }

    public boolean isImage() {
        return isImage;
    }

    public long getSize() {
        return size;
    }

    public String getContent() {
        return content;
    }

    public Map<String,Object> getMap() {
        HashMap<String, Object> map = new HashMap<>();
        map.put("content",getContent());
        map.put("image",isImage);
        if( !isImage() ){
            map.put("thumbnail",thumbnail);
        }
        return map;
    }
}
