package com.example.afrishop_v3.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Formula;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import java.util.Date;

@Entity
@Getter
@Setter
public class Comment extends Model {
    @JsonIgnore
    @ManyToOne(cascade = CascadeType.ALL)
    private Post post;

    @ManyToOne()
    private TbCfUserInfo userInfo;

    private String content;

    @JsonProperty
    public Date date(){
        return createDate;
    }


    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM comment_like c WHERE c.comment_id=id)")
    private int likes;


    @Formula(value = "(SELECT IFNULL(COUNT(c.id),0) FROM reply c WHERE c.comment_id=id)")
    private int replies;


    public void setUserInfo(TbCfUserInfo userInfo) {
        this.userInfo = userInfo;
    }
}
