package com.example.afrishop_v3.models;

import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Optional;

@Entity
@Getter
@Setter
public class Bonus extends Model {
    @ManyToOne()
    private TbCfUserInfo userInfo;

    @ManyToOne()
    private Post post;

    @ManyToOne()
    private Item item;

    @ManyToOne()
    private TbCfStationItem stationItem;

    private BigDecimal amount;

    private String orderId;

    private String account;

    private String accountName;

    private String names;

    private String email;

    @Transient
    private String productSharer;

    private boolean status = false;

    @Column(columnDefinition = "is_withdraw", name = "is_withdraw")
    public boolean withdraw = false;

    @Transient
    private String product;

    @Transient
    private String sharer;


    private double percentage;

    @Transient
    private String userId;

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOrderId() {
        return orderId;
    }

    public String getProduct() {
        return product;
    }

    public String getSharer() {
        return sharer;
    }

    public Post getPost() {
        return post;
    }

    public String getProductSharer() {
        return productSharer;
    }

    public BigDecimal getAmount() {
        return (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) ? BigDecimal.ZERO : amount.setScale(3, BigDecimal.ROUND_DOWN);
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    private void withDrawChange() {
        this.withdraw = true;
    }

    public void reverseAmount() {
        this.withDrawChange();
        amount = getAmount().multiply(BigDecimal.valueOf(-1));
    }

    public String getUserId() {
        return userInfo == null ? null : userInfo.getUserId();
    }


    public void setPercentage(double percentage) {
        this.percentage = percentage;
    }

    public void setPost(Post post) {
        this.post = post;
    }


    public void setUserInfo(TbCfUserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public Optional<String> userId() {
        return userInfo == null ? Optional.empty() : Optional.ofNullable(userInfo.getUserId());
    }

    public void setItem(Item item) {
        this.item = item;
    }

    public void setStationItem(TbCfStationItem stationItem) {
        this.stationItem = stationItem;
    }

    public Date getDate() {
        return createDate;
    }
}
