package com.example.afrishop_v3.models;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 实体
 * 表名 attributes
 *
 * @author lipengjun
 * @date 2020-12-21 15:41:01
 */
@Entity
public class Attributes implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 商品属性ID
     */
    @Id
    private String id;
    /**
     * 属性名
     */
    private String attrName;

    /**
     * 状态 0：隐藏 1：正常
     */
    private Integer status;
    /**
     * 排序
     */
    private Integer sort;
    /**
     * 是否必须 0：否 1：是
     */
    @Column(name = "is_need")
    private boolean isNeed;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;

    @OneToMany(mappedBy = "attributes", cascade = CascadeType.ALL)
    @Transient
    private List<AttributesDesc> descList;

    public List<AttributesDesc> getDescList() {
        return descList;
    }

    public void setDescList(List<AttributesDesc> descList) {
        this.descList = descList;
    }

    /**
     * 设置：商品属性ID
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * 获取：商品属性ID
     */
    public String getId() {
        return id;
    }

    /**
     * 设置：属性名
     */
    public void setAttrName(String attrName) {
        this.attrName = attrName;
    }

    /**
     * 获取：属性名
     */
    public String getAttrName() {
        return attrName;
    }

    /**
     * 设置：状态 0：隐藏 1：正常
     */
    public void setStatus(Integer status) {
        this.status = status;
    }

    /**
     * 获取：状态 0：隐藏 1：正常
     */
    public Integer getStatus() {
        return status;
    }

    /**
     * 设置：排序
     */
    public void setSort(Integer sort) {
        this.sort = sort;
    }

    /**
     * 获取：排序
     */
    public Integer getSort() {
        return sort;
    }

    public boolean isNeed() {
        return isNeed;
    }

    public void setNeed(boolean need) {
        isNeed = need;
    }

    /**
     * 设置：创建时间
     */
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    /**
     * 获取：创建时间
     */
    public Date getCreateTime() {
        return createTime;
    }

    /**
     * 设置：更新时间
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    /**
     * 获取：更新时间
     */
    public Date getUpdateTime() {
        return updateTime;
    }
}
