package com.example.afrishop_v3.enums;


/**
 * 翻译语言种类缩写
 * 
 * @author G
 */
public enum TranslateLanguageEnum implements EnumItemable<TranslateLanguageEnum> {

	ZH("中文", "zh"),
	EN("英文", "en"),
	JP("日文", "jp"),
	KR("韩文", "kr"),
	FR("法文", "fr"),
	ES("西班牙文", "es"),
	IT("意大利文", "it"),
	DE("德文", "de"),
	TR("土耳其文", "tr"),
	RU("俄文", "ru"),
	PT("葡萄牙文", "pt"),
	VI("越南文", "vi"),
	ID("印度尼西亚文", "id"),
	MS("马来西亚文", "ms"),
	TH("泰文", "th"),
	AUTO("自动识别（中英互译）", "auto");

	private String label;
	private String value;

	TranslateLanguageEnum(String label, String value) {
		this.label = label;
		this.value = value;
	}

	public String getLabel() {
		return this.label;
	}

	public String getValue() {
		return this.value;
	}
}
