package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.TbCfVisit;
import com.example.afrishop_v3.repository.TbCfVisitRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import com.example.afrishop_v3.util.IdUtil;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Date;

/**
 * @Auther: wudepeng
 * @Date: 2020/12/01
 * @Description:
 */
@RestController
@RequestMapping("/visit")
public class VisitController extends Controller {

    private final HttpServletRequest request; //自动注入request
    private final TbCfVisitRepository visitRepository;
//    private final AuthenticationUser user;

    public VisitController(HttpServletRequest request, TbCfVisitRepository visitRepository) {
        this.request = request;
        this.visitRepository = visitRepository;

    }


    @PostMapping("/getVisitCount")
    public Result getVisitCount(@RequestBody TbCfVisit visit) {

        String ip = getRealIpAddress(request);
//        System.err.println(ip);
        Long count = visitRepository.existsByVisitUser(visit.getSource(), ip);
        if (count == 0) {
            //保存访问记录
            visit.setId(IdUtil.createIdbyUUID());
            visit.setIp(ip);
            visit.setVisitTime(new Date());
            visitRepository.save(visit);
        }
        return new Result();
    }
}
