package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.models.TbCfVersion;
import com.example.afrishop_v3.repository.TbCfVersionRepository;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/version")
public class VersionController {
    private final TbCfVersionRepository repository;

    public VersionController(TbCfVersionRepository repository) {
        this.repository = repository;
    }

    @RequestMapping("/getVersionCode")
    @GetMapping
    public List<TbCfVersion> getList(@RequestParam(required = false) String code){
        return code == null ? (List<TbCfVersion>) repository.findAll() : repository.findAllByVersionCode(code);
    }
}
