package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.Term;
import com.example.afrishop_v3.repository.TermRepository;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

/**
 * @Auther: wudepeng
 * @Date: 2020/11/26
 * @Description:条目管理
 */
@RestController
@RequestMapping("/term")
public class TermController {


    private final TermRepository termRepository;

    public TermController(TermRepository termRepository) {
        this.termRepository = termRepository;
    }


    @GetMapping
    public Result getAllTerms() {
        //1.查询所有一级条款
        List<Term> termList = termRepository.findByParentId("0");
        List<Map> list = new ArrayList<>();
        termList.forEach(term -> {
            Map<String, Object> map = new HashMap<>();
            //2.根据一级条款Id查询子条款
            List<Term> childrenList = termRepository.findByParentId(term.getId());
            map.put("parent", term);
            map.put("children", childrenList);
            list.add(map);

        });
        return new Result<>(list);
    }


    @GetMapping("/getTermInfo/{termId}")
    public Result getTermInfo(@PathVariable("termId") String termId) {
        if (StringUtils.isBlank(termId)) {
            return new Result().setCode(ResultCodeEnum.SERVICE_ERROR.getCode())
                    .setMessage("The parameter cannot be null");
        }

        return new Result<>(termRepository.findById(termId));
    }

}
