package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.bo.DetailParamVo;
import com.example.afrishop_v3.service.SpiderService;
import net.sf.json.JSONObject;
import org.apache.http.Consts;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;

/**
 * 爬取网络相关数据Controller
 *
 * @author G
 * @date 2019-08-22 15:51:16
 */

@RestController
@RequestMapping("/spider")
public class SpiderController {

    private final SpiderService spiderService;

    public SpiderController(SpiderService spiderService) {
        this.spiderService = spiderService;
    }

    @PostMapping("/item/detail")
    public Result getItemDetail(@RequestBody DetailParamVo detailParamVo) throws InterruptedException, ExecutionException, URISyntaxException, IOException, TimeoutException {
        String targetUrl= URLDecoder.decode(detailParamVo.getTargetUrl(), Consts.UTF_8.name());
        JSONObject itemMap=spiderService.getItemDetail(targetUrl);
        return new Result<>(itemMap,"商品规格信息");
    }


}
