package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.inter_face.CommentCount;
import com.example.afrishop_v3.models.TbCfItemComment;
import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.TbCfItemCommentRepository;
import com.example.afrishop_v3.repository.UserRepository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Optional;

@RestController
@RequestMapping("shopify")
public class ShopifyController {
    private final TbCfItemCommentRepository repository;
    private final UserRepository userRepository;
    private static Logger logger = LoggerFactory.getLogger(ShopifyController.class);

    public ShopifyController(TbCfItemCommentRepository repository, UserRepository userRepository) {
        this.repository = repository;
        this.userRepository = userRepository;
    }

    @GetMapping("/querycomments")
    public Result queryComments(@RequestParam(value = "itemId") String itemId,
                                 @RequestParam(value = "pageNum", defaultValue = "0") Integer pageNum,
                                @RequestParam(value = "pageSize", defaultValue = "10") Integer pageSize,
                                @RequestParam(value = "userId", required = false) String userId) {
        PageRequest request = PageRequest.of(pageNum, pageSize);
        if(StringUtils.isNotBlank(userId) ){
            Optional<TbCfUserInfo> userOptional = userRepository.findById(userId);
            if( userOptional.isPresent() ){
                TbCfUserInfo user = userOptional.get();
                Page<CommentCount> page = repository.findAllByItemIdAndUser(itemId, user, request);
                //Iterate to check if item is liked by selected user
                page.getContent().forEach(v-> v.getItemComment().setLike(v.getCommented() != null && v.getCommented() > 0));
                Page<TbCfItemComment> map = page.map(CommentCount::getItemComment);
                return new Result<>(map);
            }else logger.info("User id not found");
        }
        Page<TbCfItemComment> list = repository.findAllByItemId(itemId, request);

        return new Result<>(list);
    }
}
