package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.ScreenImage;
import com.example.afrishop_v3.repository.ScreenImageRepository;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Auther: wudepeng
 * @Date: 2021/03/04
 * @Description:开屏图管理
 */
@RestController
@RequestMapping("/screen")
public class ScreenImageController {

    private final ScreenImageRepository screenImageRepository;

    public ScreenImageController(ScreenImageRepository screenImageRepository) {
        this.screenImageRepository = screenImageRepository;
    }

    @GetMapping("/getScreenImage")
    public Result getScreenImage() {
        ScreenImage image = screenImageRepository.findFirstByStatus(1);
        return new Result<>(image);
    }


}
