package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.models.Network;
import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.NetworkRepository;
import com.example.afrishop_v3.repository.UserRepository;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@RestController
@RequestMapping("/discover/networking")
public class NetworkController {
    private final NetworkRepository repository;
    private final UserRepository userRepository;

    public NetworkController(NetworkRepository repository, UserRepository userRepository) {
        this.repository = repository;
        this.userRepository = userRepository;
    }


    //Save network by user id
    @PostMapping(value = "/saveNetwork")
    public Network saveNetwork(@ModelAttribute("Network") Network network) {

        if( network.getNetworkId() == null || network.getUserId() == null){
            return null;
        }

        if (repository.existsByUserInfo_UserIdAndNetworkInfo_UserId(network.getUserId(), network.getNetworkId()))
            return repository.findByUserInfo_UserIdAndNetworkInfo_UserId(network.getUserId(), network.getNetworkId());
        else return repository.save(network);
    }

    //Save network by invitation code
    @PostMapping(value = "/saveNetwork2")
    public Network saveNetwork2(@ModelAttribute("Network") Network network) {

        if( network.getCode() == null || network.getUserId() == null){
            return null;
        }

        if (repository.existsByUserInfo_CodeAndNetworkInfo_UserId(network.getCode(), network.getNetworkId()))
            return repository.findByUserInfo_CodeAndNetworkInfo_UserId(network.getCode(), network.getNetworkId());
        else if ( userRepository.existsByCode(network.getCode())){
            Optional<TbCfUserInfo> byCode = userRepository.findByCode(network.getCode());
            if( byCode.isPresent() ) {
                network.setUserInfo(byCode.get());
                return repository.save(network);
            }
        }
        return null;
    }

    //Get user network list
    @GetMapping(value = "/networksByUserId/{userId}")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<TbCfUserInfo> getList(@PathVariable(value = "userId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {

            List<TbCfUserInfo> collect = repository.findAllByUserInfo_UserIdOrderByIdDesc(id, PageRequest.of(pageNo, pageSize)).toList().stream().map(Network::getNetworkInfo).collect(Collectors.toList());

//            for (TbCfUserInfo user : collect){
//
//                Query nativeQuery = manager.createNativeQuery("select IFNULL(sum(b.amount),0.0) as data FROM bonus b where b.user_info_user_id=:me and b.user_info_user_id IN (SELECT x.user_info_user_id FROM network x WHERE x.network_info_user_id=:id) ");
//                nativeQuery.setParameter("id",user.getUserId());
//                nativeQuery.setParameter("me",id);
//                user.networkAmount = (BigDecimal) nativeQuery.getSingleResult();
//            }

            return collect;
    }
}
