package com.example.afrishop_v3.controllers;


import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.models.PostLike;
import com.example.afrishop_v3.repository.LikeRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/discover/like")
public class LikeController {
    private final LikeRepository repository;
    private static Logger logger = LoggerFactory.getLogger(LikeController.class);

    public LikeController(LikeRepository repository) {
        this.repository = repository;
    }

    //Get List of Likes by post id
    @GetMapping(value = "/likesByPostId/{postId}")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<PostLike> getList(@PathVariable(value = "postId") String id, @RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAllByPost_Id(id, PageRequest.of(pageNo, pageSize)).toList();
    }

    //Like a post
    @PostMapping(value = "/saveLike/{status}")
    public Result saveProduct(@PathVariable(value = "status") boolean status, @ModelAttribute("PostLike") PostLike like) {
        //status is true if mean to like post
        //status if false if mean to be disliked
        if (status) {
            //check existence before deleting
            if( !repository.existsByUserInfo_UserIdAndPost_Id(like.getUserId(),like.getPostId())) repository.save(like);
            else logger.info("Not found");
        }else repository.removeByUser_IdAndPost_Id(like.getUserId(), like.getPostId());
        return new Result();
    }
}
