package com.example.afrishop_v3.controllers;

import com.alibaba.fastjson.JSONObject;
import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.config.DpoConfiguration;
import com.example.afrishop_v3.enums.DeliveryStatusEnum;
import com.example.afrishop_v3.enums.OrderStatusEnum;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.*;
import com.example.afrishop_v3.repository.*;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import com.example.afrishop_v3.util.DataUtils;
import com.example.afrishop_v3.util.DateUtil;
import com.example.afrishop_v3.util.HttpsUtil;
import com.example.afrishop_v3.util.IdUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;

@RestController
@RequestMapping("/dpo")
public class DpoPayController extends Controller {
    private static Logger logger = LoggerFactory.getLogger(DpoPayController.class);

    private final TbCfOrderRepository repository;
    private final UserRepository userRepository;
    private final TbCfFinanceRepository financeRepository;
    private final AuthenticationUser user;
    private final DpoConfiguration config;
    private final NetworkRepository networkRepository;
    private final BonusRepository bonusRepository;
    private final PostRepository postRepository;
    private final TbCfOrderRepository orderRepository;


    public DpoPayController(TbCfOrderRepository repository, UserRepository userRepository, TbCfFinanceRepository financeRepository, AuthenticationUser user, DpoConfiguration config, NetworkRepository networkRepository, BonusRepository bonusRepository, PostRepository postRepository, TbCfOrderRepository orderRepository) {
        this.repository = repository;
        this.userRepository = userRepository;
        this.financeRepository = financeRepository;
        this.user = user;
        this.config = config;
        this.networkRepository = networkRepository;
        this.bonusRepository = bonusRepository;
        this.postRepository = postRepository;
        this.orderRepository = orderRepository;
    }

    @GetMapping("/notify/web")
    public void payNotifyWeb(HttpServletRequest request, HttpServletResponse response) throws IOException {
//        Result result = new Result();
//        try {
        System.out.println("DPO支付回调");
        //订单号
        String orderId = request.getParameter("CompanyRef");
        //交易ID
        String transId = request.getParameter("TransID");
        //交易令牌
        String transToken = request.getParameter("TransactionToken");
        System.err.println("transID:" + transId);
        System.err.println("transToken:" + transToken);
        //logger.info("DPO支付：" + "开始支付校验");
//        Optional<TbCfOrder> byId = repository.findById(orderId);
//        String orderSource = null;
//        if (byId.isPresent()) {
//            orderSource = byId.get().getOrderSource().toString();
//        }
        if (!StringUtils.isBlank(orderId) && !StringUtils.isBlank(transToken)) {
            boolean verifyPay = verifyPay(transToken, orderId);
            if (verifyPay) {
                //logger.info("DPO支付：" + "支付校验成功");
//                result.setMessage("Pay for success");
//                result.setCode(ResultCodeEnum.SUCCESS.getCode());
                response.sendRedirect(config.getSuccessUrl());
            } else {
                response.sendRedirect(config.getFailedUrl());

            }
        }

//        } catch (Exception e) {
//            return new Result<>(result,ResultCodeEnum.SERVICE_ERROR.getCode(), "Pay for failure");
//            //logger.error("DPO支付回调发生异常--->>>" + e.toString());
//        }
    }

    @GetMapping("/notify")
    public Result payNotify(HttpServletRequest request, HttpServletResponse response) throws IOException {
//        Result result = new Result();
//        try {
        System.out.println("DPO支付回调");
        //订单号
        String orderId = request.getParameter("CompanyRef");
        //交易ID
        String transId = request.getParameter("TransID");
        //交易令牌
        String transToken = request.getParameter("TransactionToken");
        System.err.println("transID:" + transId);
        System.err.println("transToken:" + transToken);
        //logger.info("DPO支付：" + "开始支付校验");
//        Optional<TbCfOrder> byId = repository.findById(orderId);
//        String orderSource = null;
//        if (byId.isPresent()) {
//            orderSource = byId.get().getOrderSource().toString();
//        }
        if (!StringUtils.isBlank(orderId) && !StringUtils.isBlank(transToken)) {
            boolean verifyPay = verifyPay(transToken, orderId);
            if (verifyPay) {
                //logger.info("DPO支付：" + "支付校验成功");
//                result.setMessage("Pay for success");
//                result.setCode(ResultCodeEnum.SUCCESS.getCode());
                return new Result(config.getSuccessUrl());
            }
        }

//        } catch (Exception e) {
//            return new Result<>(result,ResultCodeEnum.SERVICE_ERROR.getCode(), "Pay for failure");
//            //logger.error("DPO支付回调发生异常--->>>" + e.toString());
//        }
        return new Result(config.getFailedUrl());
    }

    @Transactional
    public boolean verifyPay(String transToken, String orderId) {
        boolean verify = false;
//        try {
        Optional<TbCfOrder> byId = repository.findById(orderId);

        if (!byId.isPresent()) return false;


        TbCfOrder order = byId.get();

        //如果数据库订单支付状态为20，说明已支付
        if (OrderStatusEnum.PAID.getValue().equals(order.getPayStatus())) {
            verify = true;
            return true;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        //拼接xml格式的参数，发送请求
        Map<String, Object> map = getParameters(transToken);
        String mapToXml = DataUtils.multilayerMapToXml(map, false);
        mapToXml = mapToXml.replaceAll("<xml>", "").replaceAll("</xml>", "");
        String resp = (String) HttpsUtil.sendHttps(config.getPaymentApi(), "POST", mapToXml, false);
        if (resp != null) {
            //将响应结果转成json格式
            String json = DataUtils.xml2json(resp);
            JSONObject jsonObject = JSONObject.parseObject(json);
            JSONObject api3G = jsonObject.getJSONObject("API3G");
            String resCode = api3G.getString("Result");
            //校验交易状态码
            if (config.getSuccessCode().equals(resCode)) {
                String userId = order.getUserId();
                Optional<TbCfUserInfo> userInfoOptional = userRepository.findById(userId);
                if (userInfoOptional.isPresent()) {
                    TbCfUserInfo user = userInfoOptional.get();
                    System.out.println("user================" + user);
                    /**
                     * Because I let go of this API (DPO /notify) permission,
                     * so now the user is anonymous, so there is no way to send messages to the user?
                     */
                    if (user.hasFcm()) {
                        sendNotification(user.getFcm(), "Order alert !!", "Order of $" + order.getRealityPay() + " has been successfully paid !!");
                    }
                }
                //获取缓存中的订单
//                    TbCfOrderVo tbCfOrderVo = (TbCfOrderVo) orderRedisCache.get(KeyConstant.ORDER_DET + orderId);
//                    //如果缓存中没有订单，则从数据库中查找
//                    if (tbCfOrderVo == null) {
//                        tbCfOrderVo = tbCfOrderDao.queryObject(orderId);
//                    }

                /**
                 * 处理支付成功的业务：更新订单，优惠券状态，生成支付明细
                 */
                //1.更新订单状态
                changeOrderState(transToken, order);
                //2.更新优惠券状态
                    /*if (!StringUtils.isBlank(tbCfOrderVo.getCouponId())) {
                        tbCfToiCouponDao.changeCoupnStatus(tbCfOrderVo.getUserId(), tbCfOrderVo.getCouponId());
                    }*/
                //3.生成支付明细
                String authurl = config.getRedirectUrl() + "?ID=" + transToken;
                TbCfFinance finance = createFinance(transToken, authurl, order);
//                    TbCfFinanceVo tbCfFinanceVo = new TbCfFinanceVo();
//                    BeanUtils.copyProperties(finance, tbCfFinanceVo);
                //校验数据库中订单支付状态
                if (OrderStatusEnum.PAID.getValue().equals(order.getPayStatus())) {
                    //支付成功
                    logger.info("DPO支付：订单号" + orderId + "支付成功，支付时间：" + dateFormat.format(new Date()));
                    verify = true;
                    //清除缓存中的订单
                    // removeRedisCache(tbCfOrderVo);
                    //生成佣金
                    Optional<TbCfOrder> optional = orderRepository.findById(orderId);
                    if (optional.isPresent()) {
                        TbCfOrder tbCfOrder = optional.get();
                        Bonus bonus = new Bonus();
                        TbCfUserInfo userInfo = new TbCfUserInfo();
                        userInfo.setUserId(tbCfOrder.getUserId());
//                        bonus.setUserId(tbCfOrder.getUserId());
                        bonus.setOrderId(orderId);
                        bonus.setAmount(tbCfOrder.getItemsPrice());

                        System.out.println("佣金-----》》》订单号：" + orderId + "=user=" + tbCfOrder.getUserId() + "=price=" + tbCfOrder.getItemsPrice());
                        saveNetworkMarketing(bonus, tbCfOrder.getUserId());
                    }

                }

            }
            if (!verify) {
                logger.error("DPO支付：订单号" + orderId + "支付失败，支付时间：" + dateFormat.format(new Date()));
                logger.error("DPO支付：状态码--->>>" + resCode);
            }
        }
//        } catch (Exception e) {
//            logger.error("DPO支付：订单号" + orderId + "支付异常--->>>" + e.toString());
//        }
        return verify;
    }

    private void changeOrderState(String transToken, TbCfOrder order) {
        //更改订单状态
        order.setUpdateTime(DateUtil.getNow());
        order.setDealTime(DateUtil.getNow());
        order.setPayId(transToken);
        order.setOrderStatus(OrderStatusEnum.PAID.getValue());
        order.setPayStatus(OrderStatusEnum.PAID.getValue());
        order.setDeliveryFlag(DeliveryStatusEnum.PROCESSING.getValue());
        repository.save(order);
    }

    private TbCfFinance createFinance(String paymentId, String url, TbCfOrder tbCfOrderVo) {
        TbCfFinance tbCfFinance = new TbCfFinance();
        tbCfFinance.setOrderId(tbCfOrderVo.getOrderId());
        tbCfFinance.setFinaceId(IdUtil.createIdbyUUID());
        tbCfFinance.setPayAccount(tbCfOrderVo.getRealityPay());
        tbCfFinance.setPayId(paymentId);
        tbCfFinance.setPayTime(new Date());
        tbCfFinance.setReceiptUrl(url);
        tbCfFinance.setPayWayCode("dpo");
        tbCfFinance.setUserId(tbCfOrderVo.getUserId());
        financeRepository.save(tbCfFinance);
        return tbCfFinance;
    }


    @PostMapping("/payment")
    public Result payment(@RequestParam("orderId") String orderId) {


        if (orderId == null || orderId.trim().isEmpty())
            return new Result(ResultCodeEnum.ILLEGAL_ARGUMENT.getCode(), "Parameters cannot be empty");

        Optional<TbCfOrder> byId = repository.findById(orderId);

        if (!byId.isPresent())
            return new Result(ResultCodeEnum.ILLEGAL_ARGUMENT.getCode(), "Order not found !");

        TbCfOrder order = byId.get();

        if (OrderStatusEnum.PAID.getValue().equals(order.getPayStatus())) {
            return new Result(ResultCodeEnum.ILLEGAL_ARGUMENT.getCode(), "Order has been paid !");
        }


        BigDecimal amount = order.getRealityPay();
        boolean amountFlag = amount.compareTo(BigDecimal.ZERO) > 0;
        //校验金额
        if (!amountFlag) {
//            logger.error("DPO支付：订单号" + orderId + "传入的金额有误");
//            payErrorInfo(result, "Wrong order amount");
            return new Result(ResultCodeEnum.ILLEGAL_ARGUMENT.getCode(), "Wrong order amount");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        //logger.info("DPO支付：订单号" + orderId + "创建交易，交易时间:" + dateFormat.format(new Date()));
        //拼接请求参数（将map对象转成xml格式）
        Map<String, Object> map = getParameters(order);
        String mapToXml = DataUtils.multilayerMapToXml(map, false);
        mapToXml = mapToXml.replaceAll("<xml>", "").replaceAll("</xml>", "");
        String resp = (String) HttpsUtil.sendHttps(config.getPaymentApi(), "POST", mapToXml, false);
        if (resp != null) {
            //将响应结果转成json格式
            String json = DataUtils.xml2json(resp);
            JSONObject jsonObject = JSONObject.parseObject(json);
            JSONObject api3G = jsonObject.getJSONObject("API3G");
            String resCode = api3G.getString("Result");
            String transToken = api3G.getString("TransToken");
            if (config.getSuccessCode().equals(resCode)) {
                HashMap<String, Object> resultMap = new HashMap<>();
                resultMap.put("transToken", transToken);
                resultMap.put("payUrl", config.getRedirectUrl() + "?ID=" + transToken);
                resultMap.put("orderInfo", order);
//                result.setData(resultMap);
//                logger.info("DPO支付：订单号" + orderId + "创建令牌成功");
                return new Result<>(resultMap, "Pay success");
            }
            //                logger.info("DPO支付：订单号" + orderId + "创建令牌失败,状态码：" + resCode);
            //                payErrorInfo(result, "DPO支付：订单号" + orderId + "创建令牌失败,状态码：" + resCode);

        }

        return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "DPO支付：订单号" + orderId + "创建令牌失败,状态码：");
    }

    private Map<String, Object> getParameters(String transToken) {
        Map<String, Object> paramMap = new HashMap<>();
        Map<String, Object> apiMap = new HashMap<>();
        apiMap.put("CompanyToken", config.getCompanyToken());
        apiMap.put("Request", config.getVerifyToken());
        apiMap.put("TransactionToken", transToken);
        paramMap.put("API3G", apiMap);
        return paramMap;
    }

    private Map<String, Object> getParameters(TbCfOrder order) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd hh:mm");
        Map<String, Object> paramMap = new HashMap<>();
        Map<String, Object> apiMap = new HashMap<>();
        Map<String, Object> tranMap = new HashMap<>();
        tranMap.put("Request", config.getCreateToken());
        tranMap.put("PaymentAmount", order.getRealityPay().setScale(2, BigDecimal.ROUND_UP));
        tranMap.put("PaymentCurrency", "USD");
        tranMap.put("CompanyRef", order.getOrderId());
        tranMap.put("CompanyRefUnique", 0);
//        logger.info("getOrderSource---------->>>>>>>>>>>>" + order.getOrderSource());
        //回调地址
        if ("2".equals(order.getOrderSource().toString()) || "3".equals(order.getOrderSource().toString())) {
            tranMap.put("RedirectURL", config.getNotifyUrl() + "/web");
        } else {
            tranMap.put("RedirectURL", config.getNotifyUrl());
        }
        System.out.println("回调地址:" + tranMap.get("RedirectURL"));
        //取消地址
        tranMap.put("BackURL", config.getBackUrl());
//        tranMap.put("PTL", 5);
        Map<String, Object> servicesMap = new HashMap<>();
        Map<String, Object> serviceMap = new HashMap<>();
        serviceMap.put("ServiceType", config.getServiceType());
        serviceMap.put("ServiceDescription", "DPO payment,name:" + order.getUserName() + ",amount:$" + order.getRealityPay());
        serviceMap.put("ServiceDate", dateFormat.format(new Date()));
        servicesMap.put("Service", serviceMap);
        apiMap.put("Transaction", tranMap);
        apiMap.put("Services", servicesMap);
        apiMap.put("CompanyToken", config.getCompanyToken());
        apiMap.put("Request", config.getCreateToken());
        paramMap.put("API3G", apiMap);
        return paramMap;
    }


    public void saveNetworkMarketing(Bonus bonus, String userId) {

        String orderId = bonus.getOrderId();

        if (orderId == null)
            logger.info("佣金：orderId为空");

        Optional<TbCfOrder> orderOptional = orderRepository.findById(orderId);

        if (!orderOptional.isPresent())
            logger.info("佣金：订单不存在");

        TbCfOrder order = orderOptional.get();

        if (!OrderStatusEnum.PAID.getValue().equals(order.getPayStatus())) {
            logger.info("佣金：订单未支付");
        }

        boolean condition = orderId != null && orderOptional.isPresent() && OrderStatusEnum.PAID.getValue().equals(order.getPayStatus()) && !StringUtils.isBlank(userId);

//        if (bonusRepository.existsByOrderId(orderId)) {
//            return new Result(ResultCodeEnum.VALIDATE_ERROR.getCode(), "Transaction already done !!!");
//        }


        BigDecimal amount = bonus.getAmount();

        if (condition) {


            Optional<TbCfUserInfo> optionalUser = userRepository.findById(userId);

            if (optionalUser.isPresent()) {

                TbCfUserInfo user = optionalUser.get();

                Post post = bonus.getPost();

                Optional<Post> postOptional = post == null ? Optional.empty() : postRepository.findById(post.getId());

                String productSharer = bonus.getProductSharer();

                Optional<TbCfUserInfo> sharer = Optional.empty();

                if (productSharer != null) {
                    sharer = userRepository.findByCode(productSharer);
                }
                //加入同步锁【DPO支付回调一直轮询，防止生成多次佣金】
                synchronized (this) {
                    boolean exists = bonusRepository.existsByOrderId(orderId);
                    if (!exists && user.invited()) {
                        BigDecimal v = amount.multiply(BigDecimal.valueOf(10)).divide(BigDecimal.valueOf(100), RoundingMode.CEILING);
                        bonus.setAmount(v);
                        bonus.setUserInfo(user);
                        bonus.setPercentage(10);
                        bonus = bonusRepository.save(bonus);
                        if (user.hasFcm()) {
                            sendNotification(user.getFcm(), "Bonus alert !!", user.display() + ", You received bonus of $" + formatter.format(v) + " in your account");
                        }
                    }
                    TbCfUserInfo bonusInc = runBonusInc(user, amount, 5, false, orderId);
                    runBonusInc(sharer.orElseGet(() -> postOptional.isPresent() ? postOptional.get().getRealUser() : bonusInc), amount, 5, postOptional.isPresent() || sharer.isPresent(), orderId);
                    //runBonusInc(bonusInc, amount, 0);
                }
            }

        }


    }

    private TbCfUserInfo runBonusInc(TbCfUserInfo user, BigDecimal amount, int percent, boolean direct, String orderId) {
        if (user == null) return null;
        Optional<Network> userCode = networkRepository.findFirstByNetworkInfoCode(user.getCode());
        if (userCode.isPresent() || direct) {
            TbCfUserInfo userInfo = direct ? user : userCode.get().getUserInfo();
            Bonus bonus = new Bonus();
            bonus.setUserInfo(userInfo);
            BigDecimal v = amount.multiply(BigDecimal.valueOf(percent));
            v = v.divide(BigDecimal.valueOf(100), RoundingMode.CEILING);
            bonus.setAmount(v);
            bonus.setPercentage(percent);
            bonus.setOrderId(orderId);
            if (userInfo != null && userInfo.invited() && !"000000".equals(userInfo.getCode())) {
                bonusRepository.save(bonus);
//                bonus = repository.save(bonus);
                if (userInfo.hasFcm()) {
                    sendNotification(userInfo.getFcm(), "Bonus alert !!", userInfo.display() + ", You received bonus of $" + formatter.format(v) + " in your account");
                }
            }
            return userInfo;
        }

        return null;
    }
}
