package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.Country;
import com.example.afrishop_v3.repository.CountryRepository;
import com.example.afrishop_v3.util.HttpsUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.testng.annotations.Test;

import javax.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Auther: wudepeng
 * @Date: 2021/01/14
 * @Description:国家管理
 */
@RestController
@RequestMapping("/country")
public class CountryController extends Controller {

    private static Logger logger = LoggerFactory.getLogger(CountryController.class);
    private final CountryRepository countryRepository;

    public CountryController(CountryRepository countryRepository) {
        this.countryRepository = countryRepository;
    }

    @GetMapping
    public Result findAllCountries(@RequestParam(value = "country", required = false) String country,
                                   HttpServletRequest request) {
        Result result = new Result();
        Map<String, Object> params = new HashMap<>();
        try {
            //所有国家
            List<Country> countries = countryRepository.findAllByCountryName(country);

            if (countries.size() == 0 || countries == null) {
                result.setData(params);
                result.setCode(ResultCodeEnum.SUCCESS.getCode());
                result.setMessage(" Sorry we don't ship to this country");
                return result;
            }

            params.put("countries", countries);

            if (StringUtils.isBlank(country)) {
                //获取客户端ip
                String ip = this.getRealIpAddress(request);
                String countryName = HttpsUtil.useIpFindCountryEn(ip);

                logger.info("ip:" + ip);
                logger.info("countryName:" + countryName);
                //根据ip查询国家
                List<Country> list = countryRepository.findAllByCountryName(countryName);
                //获取默认的国家
                Optional<Country> defaultCountry = list.stream().findFirst();
                Optional<Country> first = countries.stream().findFirst();
                params.put("defaultCountry", defaultCountry.orElseGet(() -> first.get()));

            }
            result.setData(params);
            result.setCode(ResultCodeEnum.SUCCESS.getCode());
            result.setMessage("Search successfully");

        } catch (Exception e) {
            result.setCode(ResultCodeEnum.SERVICE_ERROR.getCode());
            result.setMessage("Search failed, please try again");
        }

        return result;
    }
}
