package com.example.afrishop_v3.controllers;

import com.example.afrishop_v3.base.Result;
import com.example.afrishop_v3.enums.ResultCodeEnum;
import com.example.afrishop_v3.models.Complain;
import com.example.afrishop_v3.models.TbCfUserInfo;
import com.example.afrishop_v3.repository.ComplainRepository;
import com.example.afrishop_v3.security.services.AuthenticationUser;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Optional;

@RestController
public class ComplainController {
    private final ComplainRepository repository;
    private final AuthenticationUser user;

    public ComplainController(ComplainRepository repository, AuthenticationUser user) {
        this.repository = repository;
        this.user = user;
    }


    //Get list of complains
    @GetMapping(value = "/complains")
    //@PreAuthorize("hasAuthority('ADMIN_USER') or hasAuthority('STANDARD_USER')")
    public List<Complain> getList(@RequestParam(value = "pageNo") Integer pageNo, @RequestParam(value = "pageSize") Integer pageSize) {
        return repository.findAll(PageRequest.of(pageNo, pageSize)).toList();
    }
}
